module reg_4bit_bench;

wire [3:0] out;
reg [3:0] in;
reg wr_en;
wire clk;
wire rst;
reg err;


clkrst clk_rst(
  .clk(clk),
  .rst(rst),
  .err(err)
);

reg_4bit myreg(
  .out(out),
  .in(in),
  .wr_en(wr_en),
  .clk(clk),
  .rst(rst)
);

initial begin
  err <= 1'b0;
  #120;
  wr_en <= 1'b0;
  
  #200;
  wr_en <= 1'b1;
  in <= 4'b1010;
  #100;
  wr_en <= 1'b0;
end

endmodule
