module seqdec_1101 (InA, Clk, Reset, Out);

input Clk;
input Reset;
input InA;

output Out;

wire [2:0] state;
wire [2:0] next_state;

statereg state_reg(
  .state(state),
  .next_state(next_state),
  .Clk(Clk),
  .Reset(Reset)
);

statelogic st_logic(
  .next_state(next_state),
  .Out(Out),
  .state(state),
  .InA(InA)
);

endmodule
