module seqdec_1101_bench;

reg InA;
wire Out;

reg Err;
wire Clk;
wire Reset;

integer k;
reg [63:0] sequenc;
reg [3:0] seq;
reg [3:0] seqp1;

seqdec_1101 seqdec (
  .InA(InA),
  .Out(Out),
  .Clk(Clk),
  .Reset(Reset)
);

clkrst clk_rst (
  .clk(Clk),
  .rst(Reset),
  .err(Err)
);

always@(posedge Clk) begin
  if (Reset == 1'b1) begin
    InA = 1'b0;
    k = 0;
    sequenc = 64'h453A427D_9876DAC6;
    seq = 4'h0;
    seqp1 = 4'h0;
  end
  else begin
    InA = sequenc[k];
    k = k + 1;
    seq[3] <= seq[2];
    seq[2] <= seq[1];
    seq[1] <= seq[0];
    seq[0] <= InA;
    seqp1 <= seq;
    
    if (k == 64) $finish;
  end
end

always@(negedge Clk) begin
  if ((Out == 1'b0) && (seqp1 == 4'b1101))
    $display("ERRORCHECK :: Out is 0 when it is expected to be 1");
  if ((Out == 1'b1) && (seqp1 != 4'b1101))
    $display("ERRORCHECK :: Out is 1 when it is expected to be 0");
end

initial begin
  Err <= 1'b0;
end

endmodule
