/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.CharClassIntervall;
import JFlex.CharClasses;
import JFlex.CharSet;
import JFlex.CharSetEnumerator;
import JFlex.DFA;
import JFlex.EOFActions;
import JFlex.LexParse;
import JFlex.LexScan;
import JFlex.Main;
import JFlex.Out;
import JFlex.Skeleton;
import JFlex.StateSet;
import JFlex.StateSetEnumerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Emitter {
    private static final int FINAL = 1;
    private static final int PUSHBACK = 2;
    private static final int LOOKEND = 4;
    private static final int NOLOOK = 8;
    static final int maxSize = 65529;
    private static final String date = new SimpleDateFormat().format(new Date());
    public static File directory;
    private File inputFile;
    private PrintWriter out;
    private Skeleton skel;
    private LexScan scanner;
    private LexParse parser;
    private DFA dfa;
    private CharSet[][] table;
    private boolean[] isTransition;
    private CharSet[] noTarget;
    private int numRows;
    private int[] rowMap;
    private boolean[] rowKilled;
    private int numCols;
    private int[] colMap;
    private boolean[] colKilled;
    private int numTableChunks;
    private CharClassIntervall[] intervalls;
    private int currentIntervall;

    public Emitter(File inputFile, LexParse parser, DFA dfa) throws IOException {
        String name = parser.scanner.className + ".java";
        File outputFile = Emitter.normalize(name, directory, inputFile);
        Out.println("Writing code to \"" + outputFile + "\"");
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        this.parser = parser;
        this.scanner = parser.scanner;
        this.inputFile = inputFile;
        this.dfa = dfa;
        this.skel = new Skeleton(this.out);
    }

    public static File normalize(String name, File path, File input) {
        File outputFile = directory == null ? (input == null || input.getParent() == null ? new File(name) : new File(input.getParent(), name)) : new File(directory, name);
        if (outputFile.exists() && !Main.no_backup) {
            File backup = new File(outputFile.toString() + "~");
            if (backup.exists()) {
                backup.delete();
            }
            if (outputFile.renameTo(backup)) {
                Out.println("Old file \"" + outputFile + "\" saved as \"" + backup + "\"");
            } else {
                Out.println("Couldn't save old file \"" + outputFile + "\", overwriting!");
            }
        }
        return outputFile;
    }

    private void println() {
        this.out.println();
    }

    private void println(String line) {
        this.out.println(line);
    }

    private void println(int i) {
        this.out.println(i);
    }

    private void print(String line) {
        this.out.print(line);
    }

    private void print(int i) {
        this.out.print(i);
    }

    private void print(int i, int tab) {
        int exp = i < 0 ? 1 : 10;
        while (tab-- > 1) {
            if (Math.abs(i) < exp) {
                this.print(" ");
            }
            exp *= 10;
        }
        this.print(i);
    }

    private void printUC(int i) {
        if (i > 255) {
            this.print("\\u");
            if (i < 4096) {
                this.print("0");
            }
            this.print(Integer.toHexString(i));
        } else {
            this.print("\\");
            this.print(Integer.toOctalString(i));
        }
    }

    private void emitScanError() {
        this.print("  private void yy_ScanError(int errorCode)");
        if (this.scanner.scanErrorException != null) {
            this.print(" throws " + this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.scanErrorException == null) {
            this.println("    throw new Error(message);");
        } else {
            this.println("    throw new " + this.scanner.scanErrorException + "(message);");
        }
        this.skel.emitNext();
        this.print("  private void yypushback(int number) ");
        if (this.scanner.scanErrorException == null) {
            this.println(" {");
        } else {
            this.println(" throws " + this.scanner.scanErrorException + " {");
        }
    }

    private void emitMain() {
        if (!(this.scanner.standalone || this.scanner.debugOption || this.scanner.cupDebug)) {
            return;
        }
        if (this.scanner.cupDebug) {
            this.println("  /**");
            this.println("   * Converts an int token code into the name of the");
            this.println("   * token by reflection on the cup symbol class/interface " + this.scanner.cupSymbol);
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   * <a href=\"http://meissner.v0.net/msd.htm\">meissner.v0.net/msd.htm</a>");
            this.println("   */");
            this.println("  private String getTokenName(int token) {");
            this.println("    try {");
            this.println("      java.lang.reflect.Field [] class_fields = sym.class.getFields();");
            this.println("      for (int i = 0; i < class_fields.length; i++) {");
            this.println("        if (class_fields[i].getInt(null) == token) {");
            this.println("          return class_fields[i].getName();");
            this.println("        }");
            this.println("      }");
            this.println("    } catch (Exception e) {");
            this.println("      e.printStackTrace(System.err);");
            this.println("    }");
            this.println("");
            this.println("    return \"UNKNOWN TOKEN\";");
            this.println("  }");
            this.println("");
            this.println("  /**");
            this.println("   * Same as " + this.scanner.functionName + " but also prints the token to standard out");
            this.println("   * for debugging.");
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   * <a href=\"http://meissner.v0.net/msd.htm\">meissner.v0.net/msd.htm</a>");
            this.println("   */");
            this.print("  public ");
            if (this.scanner.tokenType == null) {
                if (this.scanner.isInteger) {
                    this.print("int");
                } else if (this.scanner.isIntWrap) {
                    this.print("Integer");
                } else {
                    this.print("Yytoken");
                }
            } else {
                this.print(this.scanner.tokenType);
            }
            this.print(" debug_");
            this.print(this.scanner.functionName);
            this.print("() throws java.io.IOException");
            if (this.scanner.lexThrow != null) {
                this.print(", ");
                this.print(this.scanner.lexThrow);
            }
            if (this.scanner.scanErrorException != null) {
                this.print(", ");
                this.print(this.scanner.scanErrorException);
            }
            this.println(" {");
            this.println("    java_cup.runtime.Symbol s = " + this.scanner.functionName + "();");
            this.print("    System.out.println( ");
            if (this.scanner.lineCount) {
                this.print("\"line:\" + (yyline+1) + ");
            }
            if (this.scanner.columnCount) {
                this.print("\" col:\" + (yycolumn+1) + ");
            }
            this.println("\" --\"+ yytext() + \"--\" + getTokenName(s." + this.scanner.cupSymbol + ") + \"--\");");
            this.println("    return s;");
            this.println("  }");
            this.println("");
        }
        if (this.scanner.standalone) {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This is a standalone scanner, i.e. it will print any unmatched");
            this.println("   * text to System.out unchanged.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        } else {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This main method is the debugging routine for the scanner.");
            this.println("   * It prints debugging information about each returned token to");
            this.println("   * System.out until the end of file is reached, or an error occured.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        }
        this.println("  public static void main(String argv[]) {");
        this.println("    if (argv.length == 0) {");
        this.println("      System.out.println(\"Usage : java " + this.scanner.className + " <inputfile>\");");
        this.println("    }");
        this.println("    else {");
        this.println("      for (int i = 0; i < argv.length; i++) {");
        this.println("        " + this.scanner.className + " scanner = null;");
        this.println("        try {");
        this.println("          scanner = new " + this.scanner.className + "( new java.io.FileReader(argv[i]) );");
        if (this.scanner.standalone) {
            this.println("          while ( !scanner.yy_atEOF ) scanner." + this.scanner.functionName + "();");
        } else if (this.scanner.cupDebug) {
            this.println("          while ( !scanner.yy_atEOF ) scanner.debug_" + this.scanner.functionName + "();");
        } else {
            this.println("          do {");
            this.println("            System.out.println(scanner." + this.scanner.functionName + "());");
            this.println("          } while (!scanner.yy_atEOF);");
            this.println("");
        }
        this.println("        }");
        this.println("        catch (java.io.FileNotFoundException e) {");
        this.println("          System.out.println(\"File not found : \\\"\"+argv[i]+\"\\\"\");");
        this.println("        }");
        this.println("        catch (java.io.IOException e) {");
        this.println("          System.out.println(\"IO error scanning file \\\"\"+argv[i]+\"\\\"\");");
        this.println("          System.out.println(e);");
        this.println("        }");
        this.println("        catch (Exception e) {");
        this.println("          System.out.println(\"Unexpected exception:\");");
        this.println("          e.printStackTrace();");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("");
    }

    private void emitNoMatch() {
        this.println("            yy_ScanError(YY_NO_MATCH);");
    }

    private void emitNextInput() {
        this.println("          if (yy_currentPos_l < yy_endRead_l)");
        this.println("            yy_input = yy_buffer_l[yy_currentPos_l++];");
        this.println("          else if (yy_atEOF) {");
        this.println("            yy_input = YYEOF;");
        this.println("            break yy_forAction;");
        this.println("          }");
        this.println("          else {");
        this.println("            // store back cached positions");
        this.println("            yy_currentPos  = yy_currentPos_l;");
        this.println("            yy_markedPos   = yy_markedPos_l;");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_pushbackPos = yy_pushbackPos_l;");
        }
        this.println("            boolean eof = yy_refill();");
        this.println("            // get translated positions and possibly new buffer");
        this.println("            yy_currentPos_l  = yy_currentPos;");
        this.println("            yy_markedPos_l   = yy_markedPos;");
        this.println("            yy_buffer_l      = yy_buffer;");
        this.println("            yy_endRead_l     = yy_endRead;");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_pushbackPos_l = yy_pushbackPos;");
        }
        this.println("            if (eof) {");
        this.println("              yy_input = YYEOF;");
        this.println("              break yy_forAction;");
        this.println("            }");
        this.println("            else {");
        this.println("              yy_input = yy_buffer_l[yy_currentPos_l++];");
        this.println("            }");
        this.println("          }");
    }

    private void emitHeader() {
        this.println("/* The following code was generated by JFlex 1.4_pre3 on " + date + " */");
        this.println("");
    }

    private void emitUserCode() {
        if (this.scanner.userCode.length() > 0) {
            this.println(this.scanner.userCode.toString());
        }
    }

    private void emitClassName() {
        this.println("/**");
        this.println(" * This class is a scanner generated by ");
        this.println(" * <a href=\"http://www.jflex.de/\">JFlex</a> 1.4_pre3");
        this.println(" * on " + date + " from the specification file");
        try {
            this.println(" * <tt>" + Emitter.toURL(this.inputFile) + "</tt>");
        }
        catch (MalformedURLException e) {
            this.println(" * (couldn't find spec. file)");
        }
        this.println(" */");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        if (this.scanner.isAbstract) {
            this.print("abstract ");
        }
        if (this.scanner.isFinal) {
            this.print("final ");
        }
        this.print("class ");
        this.print(this.scanner.className);
        if (this.scanner.isExtending != null) {
            this.print(" extends ");
            this.print(this.scanner.isExtending);
        }
        if (this.scanner.isImplementing != null) {
            this.print(" implements ");
            this.print(this.scanner.isImplementing);
        }
        this.println(" {");
    }

    private void emitLexicalStates() {
        Enumeration stateNames = this.scanner.states.names();
        while (stateNames.hasMoreElements()) {
            String name = (String)stateNames.nextElement();
            int num = this.scanner.states.getNumber(name);
            if (this.scanner.bolUsed) {
                this.println("  public static final int " + name + " = " + 2 * num + ";");
                continue;
            }
            this.println("  public static final int " + name + " = " + this.dfa.lexState[2 * num] + ";");
        }
        if (this.scanner.bolUsed) {
            this.println("");
            this.println("  /**");
            this.println("   * YY_LEXSTATE[l] is the state in the DFA for the lexical state l");
            this.println("   * YY_LEXSTATE[l+1] is the state in the DFA for the lexical state l");
            this.println("   *                  at the beginning of a line");
            this.println("   * l is of the form l = 2*k, k a non negative integer");
            this.println("   */");
            this.println("  private static final int YY_LEXSTATE[] = { ");
            int j = 0;
            this.print("    ");
            int i = 0;
            while (i < this.dfa.lexState.length - 1) {
                this.print(this.dfa.lexState[i], 2);
                this.print(", ");
                if (++j >= 16) {
                    this.println();
                    this.print("    ");
                    j = 0;
                }
                ++i;
            }
            this.println(this.dfa.lexState[i]);
            this.println("  };");
        }
    }

    private void emitDynInitHead(int chunk) {
        this.println("  /** ");
        this.println("   * The packed transition table of the DFA (part " + chunk + ")");
        this.println("   */");
        this.println("  private static final String yy_packed" + chunk + " = ");
    }

    private int UTF8Length(int value) {
        if (value < 0 || value > 65535) {
            throw new Error("not a char value (" + value + ")");
        }
        if (value == 0) {
            return 2;
        }
        if (value <= 127) {
            return 1;
        }
        if (value < 1024) {
            return 2;
        }
        if (value <= 2047) {
            return 3;
        }
        return 3;
    }

    private void emitDynamicInit() {
        this.emitDynInitHead(this.numTableChunks++);
        int n = 0;
        this.print("    \"");
        int count = 0;
        int value = this.dfa.table[0][0];
        int UTF8Length = 0;
        int i = 0;
        while (i < this.dfa.numStates) {
            if (!this.rowKilled[i]) {
                int c = 0;
                while (c < this.dfa.numInput) {
                    if (!this.colKilled[c]) {
                        if (this.dfa.table[i][c] == value) {
                            ++count;
                        } else {
                            this.printUC(count);
                            this.printUC(value + 1);
                            UTF8Length += this.UTF8Length(count) + this.UTF8Length(value + 1);
                            if ((n += 2) >= 16) {
                                this.print("\"+");
                                this.println();
                                this.print("    \"");
                                n = 0;
                            }
                            count = 1;
                            value = this.dfa.table[i][c];
                            if (UTF8Length >= 65529) {
                                UTF8Length = 0;
                                this.println("\";");
                                this.println();
                                this.emitDynInitHead(this.numTableChunks++);
                                this.print("    \"");
                                n = 0;
                            }
                        }
                    }
                    ++c;
                }
            }
            ++i;
        }
        this.printUC(count);
        this.printUC(value + 1);
        UTF8Length += this.UTF8Length(count) + this.UTF8Length(value + 1);
        this.println("\";");
        this.println();
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        this.println("  private static final int yytrans [] = yy_unpack();");
        this.println();
    }

    private void emitDynamicInitFunction() {
        this.println();
        this.println("  /** ");
        this.println("   * Unpacks the split, compressed DFA transition table.");
        this.println("   *");
        this.println("   * @return the unpacked transition table");
        this.println("   */");
        this.println("  private static int [] yy_unpack() {");
        this.println("    int [] trans = new int[" + this.numRows * this.numCols + "];");
        this.println("    int offset = 0;");
        int i = 0;
        while (i < this.numTableChunks) {
            this.println("    offset = yy_unpack(yy_packed" + i + ", offset, trans);");
            ++i;
        }
        this.println("    return trans;");
        this.println("  }");
        this.println();
        this.println("  /** ");
        this.println("   * Unpacks the compressed DFA transition table.");
        this.println("   *");
        this.println("   * @param packed   the packed transition table");
        this.println("   * @return         the index of the last entry");
        this.println("   */");
        this.println("  private static int yy_unpack(String packed, int offset, int [] trans) {");
        this.println("    int i = 0;       /* index in packed string  */");
        this.println("    int j = offset;  /* index in unpacked array */");
        this.println("    int l = packed.length();");
        this.println("    while (i < l) {");
        this.println("      int count = packed.charAt(i++);");
        this.println("      int value = packed.charAt(i++);");
        this.println("      value--;");
        this.println("      do trans[j++] = value; while (--count > 0);");
        this.println("    }");
        this.println("    return j;");
        this.println("  }");
    }

    private void emitCharMapInitFunction() {
        CharClasses cl = this.parser.getCharClasses();
        if (cl.getMaxCharCode() < '\u0100') {
            return;
        }
        this.println("");
        this.println("  /** ");
        this.println("   * Unpacks the compressed character translation table.");
        this.println("   *");
        this.println("   * @param packed   the packed character translation table");
        this.println("   * @return         the unpacked character translation table");
        this.println("   */");
        this.println("  private static char [] yy_unpack_cmap(String packed) {");
        this.println("    char [] map = new char[0x10000];");
        this.println("    int i = 0;  /* index in packed string  */");
        this.println("    int j = 0;  /* index in unpacked array */");
        this.println("    while (i < " + 2 * this.intervalls.length + ") {");
        this.println("      int  count = packed.charAt(i++);");
        this.println("      char value = packed.charAt(i++);");
        this.println("      do map[j++] = value; while (--count > 0);");
        this.println("    }");
        this.println("    return map;");
        this.println("  }");
    }

    private void emitYYTrans() {
        int n = 0;
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        this.println("  private static final int yytrans [] = {");
        boolean isFirstRow = true;
        this.print("    ");
        int i = 0;
        while (i < this.dfa.numStates) {
            if (!this.rowKilled[i]) {
                int c = 0;
                while (c < this.dfa.numInput) {
                    if (!this.colKilled[c]) {
                        if (n >= 10) {
                            this.println();
                            this.print("    ");
                            n = 0;
                        }
                        this.print(this.dfa.table[i][c]);
                        if (i != this.dfa.numStates - 1 || c != this.dfa.numInput - 1) {
                            this.print(", ");
                        }
                        ++n;
                    }
                    ++c;
                }
            }
            ++i;
        }
        this.println();
        this.println("  };");
    }

    private void emitRowMap() {
        this.println("  /** ");
        this.println("   * Translates a state to a row index in the transition table");
        this.println("   */");
        this.println("  private static final int yy_rowMap [] = { ");
        int n = 0;
        this.print("    ");
        int i = 0;
        while (i < this.dfa.numStates - 1) {
            this.print(this.rowMap[i] * this.numCols, 5);
            this.print(", ");
            if (++n >= 10) {
                this.println();
                this.print("    ");
                n = 0;
            }
            ++i;
        }
        this.print(this.rowMap[i] * this.numCols, 5);
        this.println();
        this.println("  };");
        this.println();
    }

    private void emitCharMapArrayUnPacked() {
        CharClasses cl = this.parser.getCharClasses();
        this.intervalls = cl.getIntervalls();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final char [] yycmap = {");
        int n = 0;
        this.print("    ");
        char max = cl.getMaxCharCode();
        int i = 0;
        while (i < this.intervalls.length && this.intervalls[i].start <= max) {
            int end = Math.min(this.intervalls[i].end, max);
            int c = this.intervalls[i].start;
            while (c <= end) {
                this.print(this.colMap[this.intervalls[i].charClass], 2);
                if (c < max) {
                    this.print(", ");
                    if (++n >= 16) {
                        this.println();
                        this.print("    ");
                        n = 0;
                    }
                }
                ++c;
            }
            ++i;
        }
        this.println();
        this.println("  };");
        this.println();
    }

    private void emitCharMapArray() {
        CharClasses cl = this.parser.getCharClasses();
        if (cl.getMaxCharCode() < '\u0100') {
            this.emitCharMapArrayUnPacked();
            return;
        }
        this.intervalls = cl.getIntervalls();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final String yycmap_packed = ");
        int n = 0;
        this.print("    \"");
        int i = 0;
        while (i < this.intervalls.length - 1) {
            int count = this.intervalls[i].end - this.intervalls[i].start + 1;
            int value = this.colMap[this.intervalls[i].charClass];
            this.printUC(count);
            this.printUC(value);
            if (++n >= 10) {
                this.println("\"+");
                this.print("    \"");
                n = 0;
            }
            ++i;
        }
        this.printUC(this.intervalls[i].end - this.intervalls[i].start + 1);
        this.printUC(this.colMap[this.intervalls[i].charClass]);
        this.println("\";");
        this.println();
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final char [] yycmap = yy_unpack_cmap(yycmap_packed);");
        this.println();
    }

    private void emitRowMapArray() {
        int value;
        this.println("");
        this.println("  /** ");
        this.println("   * Translates a state to a row index in the transition table (packed version)");
        this.println("   */");
        this.println("  final private static String yy_rowMap_packed = ");
        int n = 0;
        this.print("    \"");
        int i = 0;
        while (i < this.dfa.numStates - 1) {
            value = this.rowMap[i] * this.numCols;
            this.printUC(value >> 16);
            this.printUC(value & 0xFFFF);
            if (++n >= 10) {
                this.println("\"+");
                this.print("    \"");
                n = 0;
            }
            ++i;
        }
        value = this.rowMap[i] * this.numCols;
        this.printUC(value >> 16);
        this.printUC(value & 0xFFFF);
        this.println("\";");
        this.println();
        this.println("  /** ");
        this.println("   * Translates a state to a row index in the transition table");
        this.println("   */");
        this.println("  final private static int [] yy_rowMap = yy_unpack_rowMap(yy_rowMap_packed);");
        this.println();
    }

    private void emitRowMapInitFunction() {
        this.println("");
        this.println("  /** ");
        this.println("   * Unpacks the compressed row translation table.");
        this.println("   *");
        this.println("   * @param packed   the packed row translation table");
        this.println("   * @return         the unpacked row translation table");
        this.println("   */");
        this.println("  private static int [] yy_unpack_rowMap(String packed) {");
        this.println("    int [] map = new int[" + this.dfa.numStates * 2 + "];");
        this.println("    int i = 0;  /* index in packed string  */");
        this.println("    int j = 0;  /* index in unpacked array */");
        this.println("    while (i < " + 2 * this.dfa.numStates + ") {");
        this.println("      int high = ((int) packed.charAt(i++)) << 16;");
        this.println("      map[j++] = high | packed.charAt(i++);");
        this.println("    }");
        this.println("    return map;");
        this.println("  }");
    }

    private void emitAttributes() {
        int attribute;
        if (this.dfa.numStates <= 0) {
            return;
        }
        this.println("  /**");
        this.println("   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>");
        this.println("   */");
        this.println("  private static final byte YY_ATTRIBUTE[] = {");
        this.print("    ");
        int i = 0;
        int j = 0;
        while (i < this.dfa.numStates - 1) {
            if (j >= 16) {
                j = 0;
                this.println();
                this.print("    ");
            }
            attribute = 0;
            if (this.dfa.isFinal[i]) {
                attribute = 1;
            }
            if (this.dfa.isPushback[i]) {
                attribute |= 2;
            }
            if (this.dfa.isLookEnd[i]) {
                attribute |= 4;
            }
            if (!this.isTransition[i]) {
                attribute |= 8;
            }
            this.print(attribute, 2);
            this.print(", ");
            ++i;
            ++j;
        }
        attribute = 0;
        if (this.dfa.isFinal[this.dfa.numStates - 1]) {
            attribute = 1;
        }
        if (this.dfa.isPushback[this.dfa.numStates - 1]) {
            attribute |= 2;
        }
        if (this.dfa.isLookEnd[this.dfa.numStates - 1]) {
            attribute |= 4;
        }
        if (!this.isTransition[this.dfa.numStates - 1]) {
            attribute |= 8;
        }
        this.print(attribute, 2);
        this.println();
        this.println("  };");
        this.println();
    }

    private void emitClassCode() {
        if (this.scanner.eofCode != null) {
            this.println("  /** denotes if the user-EOF-code has already been executed */");
            this.println("  private boolean yy_eof_done;");
            this.println("");
        }
        if (this.scanner.classCode != null) {
            this.println("  /* user code: */");
            this.println(this.scanner.classCode);
        }
    }

    private void emitConstructorDecl() {
        this.print("  ");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        this.print(this.scanner.className);
        this.print("(java.io.Reader in)");
        if (this.scanner.initThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.initThrow);
        }
        this.println(" {");
        if (this.scanner.initCode != null) {
            this.print("  ");
            this.print(this.scanner.initCode);
        }
        this.println("    this.yy_reader = in;");
        this.println("  }");
        this.println();
        this.println("  /**");
        this.println("   * Creates a new scanner.");
        this.println("   * There is also java.io.Reader version of this constructor.");
        this.println("   *");
        this.println("   * @param   in  the java.io.Inputstream to read input from.");
        this.println("   */");
        this.print("  ");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        this.print(this.scanner.className);
        this.print("(java.io.InputStream in)");
        if (this.scanner.initThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.initThrow);
        }
        this.println(" {");
        this.println("    this(new java.io.InputStreamReader(in));");
        this.println("  }");
    }

    private void emitDoEOF() {
        if (this.scanner.eofCode == null) {
            return;
        }
        this.println("  /**");
        this.println("   * Contains user EOF-code, which will be executed exactly once,");
        this.println("   * when the end of file is reached");
        this.println("   */");
        this.print("  private void yy_do_eof()");
        if (this.scanner.eofThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.eofThrow);
        }
        this.println(" {");
        this.println("    if (!yy_eof_done) {");
        this.println("      yy_eof_done = true;");
        this.println("    " + this.scanner.eofCode);
        this.println("    }");
        this.println("  }");
        this.println("");
        this.println("");
    }

    private void emitLexFunctHeader() {
        this.print("  public ");
        if (this.scanner.tokenType == null) {
            if (this.scanner.isInteger) {
                this.print("int");
            } else if (this.scanner.isIntWrap) {
                this.print("Integer");
            } else {
                this.print("Yytoken");
            }
        } else {
            this.print(this.scanner.tokenType);
        }
        this.print(" ");
        this.print(this.scanner.functionName);
        this.print("() throws java.io.IOException");
        if (this.scanner.lexThrow != null) {
            this.print(", ");
            this.print(this.scanner.lexThrow);
        }
        if (this.scanner.scanErrorException != null) {
            this.print(", ");
            this.print(this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.useRowMap) {
            this.println("    int [] yytrans_l = yytrans;");
            this.println("    int [] yy_rowMap_l = yy_rowMap;");
            this.println("    byte [] yy_attr_l = YY_ATTRIBUTE;");
        }
        if (this.scanner.lookAheadUsed) {
            this.println("    int yy_pushbackPos_l = yy_pushbackPos = -1;");
            this.println("    boolean yy_was_pushback;");
        }
        this.skel.emitNext();
        if (this.scanner.charCount) {
            this.println("      yychar+= yy_markedPos_l-yy_startRead;");
            this.println("");
        }
        if (this.scanner.lineCount || this.scanner.columnCount) {
            this.println("      boolean yy_r = false;");
            this.println("      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;");
            this.println("                                                             yy_currentPos_l++) {");
            this.println("        switch (yy_buffer_l[yy_currentPos_l]) {");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          yy_r = false;");
            this.println("          break;");
            this.println("        case '\\r':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          yy_r = true;");
            this.println("          break;");
            this.println("        case '\\n':");
            this.println("          if (yy_r)");
            this.println("            yy_r = false;");
            this.println("          else {");
            if (this.scanner.lineCount) {
                this.println("            yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("            yycolumn = 0;");
            }
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          yy_r = false;");
            if (this.scanner.columnCount) {
                this.println("          yycolumn++;");
            }
            this.println("        }");
            this.println("      }");
            this.println();
            if (this.scanner.lineCount) {
                this.println("      if (yy_r) {");
                this.println("        // peek one character ahead if it is \\n (if we have counted one line too much)");
                this.println("        boolean yy_peek;");
                this.println("        if (yy_markedPos_l < yy_endRead_l)");
                this.println("          yy_peek = yy_buffer_l[yy_markedPos_l] == '\\n';");
                this.println("        else if (yy_atEOF)");
                this.println("          yy_peek = false;");
                this.println("        else {");
                this.println("          boolean eof = yy_refill();");
                this.println("          yy_markedPos_l = yy_markedPos;");
                this.println("          yy_buffer_l = yy_buffer;");
                this.println("          if (eof) ");
                this.println("            yy_peek = false;");
                this.println("          else ");
                this.println("            yy_peek = yy_buffer_l[yy_markedPos_l] == '\\n';");
                this.println("        }");
                this.println("        if (yy_peek) yyline--;");
                this.println("      }");
            }
        }
        if (this.scanner.bolUsed) {
            this.println("      if (yy_markedPos_l > yy_startRead) {");
            this.println("        switch (yy_buffer_l[yy_markedPos_l-1]) {");
            this.println("        case '\\n':");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            this.println("          yy_atBOL = true;");
            this.println("          break;");
            this.println("        case '\\r': ");
            this.println("          if (yy_markedPos_l < yy_endRead_l)");
            this.println("            yy_atBOL = yy_buffer_l[yy_markedPos_l] != '\\n';");
            this.println("          else if (yy_atEOF)");
            this.println("            yy_atBOL = false;");
            this.println("          else {");
            this.println("            boolean eof = yy_refill();");
            this.println("            yy_markedPos_l = yy_markedPos;");
            this.println("            yy_buffer_l = yy_buffer;");
            this.println("            if (eof) ");
            this.println("              yy_atBOL = false;");
            this.println("            else ");
            this.println("              yy_atBOL = yy_buffer_l[yy_markedPos_l] != '\\n';");
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          yy_atBOL = false;");
            this.println("        }");
            this.println("      }");
        }
        this.skel.emitNext();
        if (this.scanner.bolUsed) {
            this.println("      if (yy_atBOL)");
            this.println("        yy_state = YY_LEXSTATE[yy_lexical_state+1];");
            this.println("      else");
            this.println("        yy_state = YY_LEXSTATE[yy_lexical_state];");
            this.println();
        } else {
            this.println("      yy_state = yy_lexical_state;");
            this.println();
        }
        if (this.scanner.lookAheadUsed) {
            this.println("      yy_was_pushback = false;");
        }
        this.skel.emitNext();
    }

    private void emitGetRowMapNext() {
        this.println("          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];");
        this.println("          if (yy_next == " + -1 + ") break yy_forAction;");
        this.println("          yy_state = yy_next;");
        this.println();
        this.println("          int yy_attributes = yy_attr_l[yy_state];");
        if (this.scanner.lookAheadUsed) {
            this.println("          if ( (yy_attributes & 2) == 2 )");
            this.println("            yy_pushbackPos_l = yy_currentPos_l;");
            this.println();
        }
        this.println("          if ( (yy_attributes & 1) == 1 ) {");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_was_pushback = (yy_attributes & 4) == 4;");
        }
        this.skel.emitNext();
        this.println("            if ( (yy_attributes & 8) == 8 ) break yy_forAction;");
        this.skel.emitNext();
    }

    private void emitTransitionTable() {
        this.transformTransitionTable();
        this.println("          yy_input = yycmap_l[yy_input];");
        this.println();
        if (this.scanner.lookAheadUsed) {
            this.println("          boolean yy_pushback = false;");
        }
        this.println("          boolean yy_isFinal = false;");
        this.println("          boolean yy_noLookAhead = false;");
        this.println();
        this.println("          yy_forNext: { switch (yy_state) {");
        int state = 0;
        while (state < this.dfa.numStates) {
            if (this.isTransition[state]) {
                this.emitState(state);
            }
            ++state;
        }
        this.println("            default:");
        this.println("              yy_ScanError(YY_ILLEGAL_STATE);");
        this.println("              break;");
        this.println("          } }");
        this.println();
        this.println("          if ( yy_isFinal ) {");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_was_pushback = yy_pushback;");
        }
        this.skel.emitNext();
        this.println("            if ( yy_noLookAhead ) break yy_forAction;");
        this.skel.emitNext();
    }

    private String escapify(String s) {
        StringBuffer result = new StringBuffer(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    result.append("\\'");
                    break;
                }
                case '\"': {
                    result.append("\\\"");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\r': {
                    if (i + 1 != s.length() && s.charAt(i + 1) == '\n') break;
                    result.append("\"+yy_NL+\"");
                    break;
                }
                case '\n': {
                    result.append("\"+yy_NL+\"");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private void emitActions() {
        Hashtable<Action, StateSet> actionTable = new Hashtable<Action, StateSet>();
        int i = 0;
        while (i < this.dfa.numStates) {
            if (this.dfa.isFinal[i]) {
                Action action = this.dfa.action[i];
                if (actionTable.get(action) == null) {
                    actionTable.put(action, new StateSet(this.dfa.numStates, i));
                } else {
                    ((StateSet)actionTable.get(action)).addState(i);
                }
            }
            ++i;
        }
        int i2 = this.dfa.numStates + 1;
        Enumeration actions2 = actionTable.keys();
        while (actions2.hasMoreElements()) {
            Action action = (Action)actions2.nextElement();
            StateSet states = (StateSet)actionTable.get(action);
            StateSetEnumerator s = states.states();
            while (s.hasMoreElements()) {
                this.println("        case " + s.nextElement() + ": ");
            }
            if (this.scanner.debugOption) {
                this.print("          System.out.println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: --\"+yytext()+\"--\");");
                this.print("          System.out.println(\"action [" + action.priority + "] {");
                this.print(this.escapify(action.content));
                this.println("}\");");
            }
            this.println("          { " + action.content + " }");
            this.println("        case " + i2++ + ": break;");
        }
    }

    private void emitEOFVal() {
        EOFActions eofActions = this.parser.getEOFActions();
        if (this.scanner.eofCode != null) {
            this.println("            yy_do_eof();");
        }
        if (eofActions.numActions() > 0) {
            this.println("            switch (yy_lexical_state) {");
            Enumeration stateNames = this.scanner.states.names();
            Hashtable<Integer, String> used = new Hashtable<Integer, String>();
            int last = this.dfa.numStates;
            while (stateNames.hasMoreElements()) {
                String name = (String)stateNames.nextElement();
                int num = this.scanner.states.getNumber(name);
                Action action = eofActions.getAction(num);
                boolean unused = true;
                if (!this.scanner.bolUsed) {
                    Integer key = new Integer(this.dfa.lexState[2 * num]);
                    boolean bl = unused = used.get(key) == null;
                    if (!unused) {
                        Out.warning("Lexical states <" + name + "> and <" + used.get(key) + "> are equivalent.");
                    } else {
                        used.put(key, name);
                    }
                }
                if (action == null || !unused) continue;
                this.println("            case " + name + ":");
                this.println("              { " + action.content + " }");
                this.println("            case " + ++last + ": break;");
            }
            this.println("            default:");
        }
        if (eofActions.getDefault() != null) {
            this.println("              { " + eofActions.getDefault().content + " }");
        } else if (this.scanner.eofVal != null) {
            this.println("              { " + this.scanner.eofVal + " }");
        } else if (this.scanner.isInteger) {
            this.println("            return YYEOF;");
        } else {
            this.println("            return null;");
        }
        if (eofActions.numActions() > 0) {
            this.println("            }");
        }
    }

    private void emitState(int state) {
        this.println("            case " + state + ":");
        this.println("              switch (yy_input) {");
        int defaultTransition = this.getDefaultTransition(state);
        int next = 0;
        while (next < this.dfa.numStates) {
            if (next != defaultTransition && this.table[state][next] != null) {
                this.emitTransition(state, next);
            }
            ++next;
        }
        if (defaultTransition != -1 && this.noTarget[state] != null) {
            this.emitTransition(state, -1);
        }
        this.emitDefaultTransition(state, defaultTransition);
        this.println("              }");
        this.println("");
    }

    private void emitTransition(int state, int nextState) {
        CharSetEnumerator chars = nextState != -1 ? this.table[state][nextState].characters() : this.noTarget[state].characters();
        this.print("                case ");
        this.print(chars.nextElement());
        this.print(": ");
        while (chars.hasMoreElements()) {
            this.println();
            this.print("                case ");
            this.print(chars.nextElement());
            this.print(": ");
        }
        if (nextState != -1) {
            if (this.dfa.isFinal[nextState]) {
                this.print("yy_isFinal = true; ");
            }
            if (this.dfa.isPushback[nextState]) {
                this.print("yy_pushbackPos_l = yy_currentPos_l; ");
            }
            if (this.dfa.isLookEnd[nextState]) {
                this.print("yy_pushback = true; ");
            }
            if (!this.isTransition[nextState]) {
                this.print("yy_noLookAhead = true; ");
            }
            if (nextState == state) {
                this.println("yy_state = " + nextState + "; break yy_forNext;");
            } else {
                this.println("yy_state = " + nextState + "; break yy_forNext;");
            }
        } else {
            this.println("break yy_forAction;");
        }
    }

    private void emitDefaultTransition(int state, int nextState) {
        this.print("                default: ");
        if (nextState != -1) {
            if (this.dfa.isFinal[nextState]) {
                this.print("yy_isFinal = true; ");
            }
            if (this.dfa.isPushback[nextState]) {
                this.print("yy_pushbackPos_l = yy_currentPos_l; ");
            }
            if (this.dfa.isLookEnd[nextState]) {
                this.print("yy_pushback = true; ");
            }
            if (!this.isTransition[nextState]) {
                this.print("yy_noLookAhead = true; ");
            }
            if (nextState == state) {
                this.println("yy_state = " + nextState + "; break yy_forNext;");
            } else {
                this.println("yy_state = " + nextState + "; break yy_forNext;");
            }
        } else {
            this.println("break yy_forAction;");
        }
    }

    private void emitPushback() {
        this.println("      if (yy_was_pushback)");
        this.println("        yy_markedPos = yy_pushbackPos_l;");
    }

    private int getDefaultTransition(int state) {
        int max = 0;
        int i = 0;
        while (i < this.dfa.numStates) {
            if (this.table[state][max] == null) {
                max = i;
            } else if (this.table[state][i] != null && this.table[state][max].size() < this.table[state][i].size()) {
                max = i;
            }
            ++i;
        }
        if (this.table[state][max] == null) {
            return -1;
        }
        if (this.noTarget[state] == null) {
            return max;
        }
        if (this.table[state][max].size() < this.noTarget[state].size()) {
            max = -1;
        }
        return max;
    }

    private void transformTransitionTable() {
        int numInput = this.parser.getCharClasses().getNumClasses() + 1;
        this.table = new CharSet[this.dfa.numStates][this.dfa.numStates];
        this.noTarget = new CharSet[this.dfa.numStates];
        int i = 0;
        while (i < this.dfa.numStates) {
            int j = 0;
            while (j < this.dfa.numInput) {
                int nextState = this.dfa.table[i][j];
                if (nextState == -1) {
                    if (this.noTarget[i] == null) {
                        this.noTarget[i] = new CharSet(numInput, this.colMap[j]);
                    } else {
                        this.noTarget[i].add(this.colMap[j]);
                    }
                } else if (this.table[i][nextState] == null) {
                    this.table[i][nextState] = new CharSet(numInput, this.colMap[j]);
                } else {
                    this.table[i][nextState].add(this.colMap[j]);
                }
                j = (char)(j + 1);
            }
            ++i;
        }
    }

    private void findActionStates() {
        this.isTransition = new boolean[this.dfa.numStates];
        int i = 0;
        while (i < this.dfa.numStates) {
            int j = 0;
            while (!this.isTransition[i] && j < this.dfa.numInput) {
                int n = j;
                j = (char)(j + 1);
                boolean bl = this.isTransition[i] = this.dfa.table[i][n] != -1;
            }
            ++i;
        }
    }

    private void reduceColumns() {
        this.colMap = new int[this.dfa.numInput];
        this.colKilled = new boolean[this.dfa.numInput];
        int translate = 0;
        this.numCols = this.dfa.numInput;
        int i = 0;
        while (i < this.dfa.numInput) {
            this.colMap[i] = i - translate;
            int j = 0;
            while (j < i) {
                int k = -1;
                boolean equal = true;
                while (equal && ++k < this.dfa.numStates) {
                    boolean bl = equal = this.dfa.table[k][i] == this.dfa.table[k][j];
                }
                if (equal) {
                    ++translate;
                    this.colMap[i] = this.colMap[j];
                    this.colKilled[i] = true;
                    --this.numCols;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void reduceRows() {
        this.rowMap = new int[this.dfa.numStates];
        this.rowKilled = new boolean[this.dfa.numStates];
        int translate = 0;
        this.numRows = this.dfa.numStates;
        int i = 0;
        while (i < this.dfa.numStates) {
            this.rowMap[i] = i - translate;
            int j = 0;
            while (j < i) {
                int k = -1;
                boolean equal = true;
                while (equal && ++k < this.dfa.numInput) {
                    boolean bl = equal = this.dfa.table[i][k] == this.dfa.table[j][k];
                }
                if (equal) {
                    ++translate;
                    this.rowMap[i] = this.rowMap[j];
                    this.rowKilled[i] = true;
                    --this.numRows;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void emit() {
        if (this.scanner.functionName == null) {
            this.scanner.functionName = "yylex";
        }
        this.reduceColumns();
        this.findActionStates();
        this.emitHeader();
        this.emitUserCode();
        this.emitClassName();
        this.skel.emitNext();
        this.println("  private static final int YY_BUFFERSIZE = " + this.scanner.bufferSize + ";");
        if (this.scanner.debugOption) {
            this.println("  private static final String yy_NL = System.getProperty(\"line.separator\");");
        }
        this.skel.emitNext();
        this.emitLexicalStates();
        this.emitCharMapArray();
        if (this.scanner.useRowMap) {
            this.reduceRows();
            this.emitRowMapArray();
            this.emitRowMapInitFunction();
            if (this.scanner.packed) {
                this.emitDynamicInit();
            } else {
                this.emitYYTrans();
            }
        }
        this.skel.emitNext();
        if (this.scanner.useRowMap) {
            this.emitAttributes();
        }
        this.skel.emitNext();
        this.emitClassCode();
        this.skel.emitNext();
        this.emitConstructorDecl();
        if (this.scanner.packed) {
            this.emitDynamicInitFunction();
        }
        this.emitCharMapInitFunction();
        this.skel.emitNext();
        this.emitScanError();
        this.skel.emitNext();
        this.emitDoEOF();
        this.skel.emitNext();
        this.emitLexFunctHeader();
        this.emitNextInput();
        if (this.scanner.useRowMap) {
            this.emitGetRowMapNext();
        } else {
            this.emitTransitionTable();
        }
        if (this.scanner.lookAheadUsed) {
            this.emitPushback();
        }
        this.skel.emitNext();
        this.emitActions();
        this.skel.emitNext();
        this.emitEOFVal();
        this.skel.emitNext();
        this.emitNoMatch();
        this.skel.emitNext();
        this.emitMain();
        this.skel.emitNext();
        this.out.close();
    }

    public static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }
}

