/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Intervall;
import java.util.Vector;

public final class IntCharSet {
    private static final boolean DEBUG = false;
    private Vector intervalls;
    private int pos;

    public IntCharSet() {
        this.intervalls = new Vector();
    }

    public IntCharSet(char c) {
        this(new Intervall(c, c));
    }

    public IntCharSet(Intervall intervall) {
        this();
        this.intervalls.addElement(intervall);
    }

    public IntCharSet(Vector chars) {
        int size = chars.size();
        this.intervalls = new Vector(size);
        int i = 0;
        while (i < size) {
            this.add((Intervall)chars.elementAt(i));
            ++i;
        }
    }

    private int indexOf(char c) {
        int start = 0;
        int end = this.intervalls.size() - 1;
        while (start <= end) {
            int check = (start + end) / 2;
            Intervall i = (Intervall)this.intervalls.elementAt(check);
            if (start == end) {
                return i.contains(c) ? start : -1;
            }
            if (c < i.start) {
                end = check - 1;
                continue;
            }
            if (c > i.end) {
                start = check + 1;
                continue;
            }
            return check;
        }
        return -1;
    }

    public IntCharSet add(IntCharSet set) {
        int i = 0;
        while (i < set.intervalls.size()) {
            this.add((Intervall)set.intervalls.elementAt(i));
            ++i;
        }
        return this;
    }

    public void add(Intervall intervall) {
        int size = this.intervalls.size();
        int i = 0;
        while (i < size) {
            Intervall elem = (Intervall)this.intervalls.elementAt(i);
            if (elem.end + '\u0001' >= intervall.start) {
                if (elem.contains(intervall)) {
                    return;
                }
                if (elem.start > intervall.end + '\u0001') {
                    this.intervalls.insertElementAt(new Intervall(intervall), i);
                    return;
                }
                if (intervall.start < elem.start) {
                    elem.start = intervall.start;
                }
                if (intervall.end <= elem.end) {
                    return;
                }
                elem.end = intervall.end;
                ++i;
                while (i < size) {
                    Intervall x = (Intervall)this.intervalls.elementAt(i);
                    if (x.start > elem.end + '\u0001') {
                        return;
                    }
                    elem.end = x.end;
                    this.intervalls.removeElementAt(i);
                    --size;
                }
                return;
            }
            ++i;
        }
        this.intervalls.addElement(new Intervall(intervall));
    }

    public void add(char singleChar) {
        this.add(new Intervall(singleChar, singleChar));
    }

    public boolean contains(char singleChar) {
        return this.indexOf(singleChar) >= 0;
    }

    public boolean contains(Intervall intervall) {
        int index = this.indexOf(intervall.start);
        if (index < 0) {
            return false;
        }
        return ((Intervall)this.intervalls.elementAt(index)).contains(intervall);
    }

    public boolean contains(IntCharSet set) {
        int i = 0;
        int j = 0;
        while (j < set.intervalls.size()) {
            Intervall y;
            Intervall x = (Intervall)this.intervalls.elementAt(i);
            if (x.contains(y = (Intervall)this.intervalls.elementAt(j))) {
                ++j;
            }
            if (x.start > y.end) {
                return false;
            }
            if (x.end >= y.start) continue;
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        IntCharSet set = (IntCharSet)o;
        if (this.intervalls.size() != set.intervalls.size()) {
            return false;
        }
        int i = 0;
        while (i < this.intervalls.size()) {
            if (!this.intervalls.elementAt(i).equals(set.intervalls.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private char min(char a, char b) {
        return a <= b ? a : b;
    }

    private char max(char a, char b) {
        return a >= b ? a : b;
    }

    public IntCharSet and(IntCharSet set) {
        IntCharSet result = new IntCharSet();
        int i = 0;
        int j = 0;
        int size = this.intervalls.size();
        int setSize = set.intervalls.size();
        while (i < size && j < setSize) {
            Intervall x = (Intervall)this.intervalls.elementAt(i);
            Intervall y = (Intervall)set.intervalls.elementAt(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            result.intervalls.addElement(new Intervall(this.max(x.start, y.start), this.min(x.end, y.end)));
            if (x.end >= y.end) {
                ++j;
            }
            if (y.end < x.end) continue;
            ++i;
        }
        return result;
    }

    public void sub(IntCharSet set) {
        int i = 0;
        int j = 0;
        int setSize = set.intervalls.size();
        while (i < this.intervalls.size() && j < setSize) {
            Intervall x = (Intervall)this.intervalls.elementAt(i);
            Intervall y = (Intervall)set.intervalls.elementAt(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            if (x.start == y.start && x.end == y.end) {
                this.intervalls.removeElementAt(i);
                ++j;
                continue;
            }
            if (x.start == y.start) {
                x.start = (char)(y.end + '\u0001');
                ++j;
                continue;
            }
            if (x.end == y.end) {
                x.end = (char)(y.start - '\u0001');
                ++i;
                ++j;
                continue;
            }
            this.intervalls.insertElementAt(new Intervall(x.start, (char)(y.start - '\u0001')), i);
            x.start = (char)(y.end + '\u0001');
            ++i;
            ++j;
        }
    }

    public boolean containsElements() {
        return this.intervalls.size() > 0;
    }

    public int numIntervalls() {
        return this.intervalls.size();
    }

    public Intervall getNext() {
        if (this.pos == this.intervalls.size()) {
            this.pos = 0;
        }
        return (Intervall)this.intervalls.elementAt(this.pos++);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("{ ");
        int i = 0;
        while (i < this.intervalls.size()) {
            result.append(this.intervalls.elementAt(i));
            ++i;
        }
        result.append(" }");
        return result.toString();
    }
}

