/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.DFA;
import JFlex.Emitter;
import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.LexParse;
import JFlex.LexScan;
import JFlex.MacroException;
import JFlex.NFA;
import JFlex.Out;
import JFlex.ScannerException;
import JFlex.Skeleton;
import JFlex.Timer;
import JFlex.gui.MainFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Main
implements ErrorMessages {
    public static final String version = "1.4_pre3";
    public static final int PACK = 0;
    public static final int TABLE = 1;
    public static final int SWITCH = 2;
    public static boolean no_minimize = false;
    public static boolean no_backup = false;
    public static int gen_method = 0;

    public static void generate(File inputFile) {
        Out.resetCounters();
        Timer totalTime = new Timer();
        Timer time = new Timer();
        LexScan scanner = null;
        LexParse parser = null;
        FileReader inputReader = null;
        totalTime.start();
        try {
            Out.println("Reading \"" + inputFile + "\"");
            inputReader = new FileReader(inputFile);
            scanner = new LexScan(inputReader);
            scanner.setFile(inputFile);
            parser = new LexParse(scanner);
        }
        catch (FileNotFoundException e) {
            Out.error("Sorry, couldn't find the file \"" + inputFile + "\"");
            throw new GeneratorException();
        }
        catch (IOException e) {
            Out.error("Sorry, error opening input file \"" + inputFile + "\"");
            throw new GeneratorException();
        }
        try {
            NFA nfa = (NFA)parser.parse().value;
            Out.checkErrors();
            if (Out.DUMP) {
                Out.dump("NFA is" + Out.NL + nfa + Out.NL);
            }
            if (Out.DOT) {
                nfa.writeDot(Emitter.normalize("nfa.dot", null, null));
            }
            Out.println(nfa.numStates + " states in NFA");
            time.start();
            DFA dfa = nfa.getDFA();
            time.stop();
            Out.time("DFA construction took " + time);
            dfa.checkActions(scanner, parser);
            nfa = null;
            if (Out.DUMP) {
                Out.dump("DFA is" + Out.NL + dfa + Out.NL);
            }
            if (Out.DOT) {
                dfa.writeDot(Emitter.normalize("dfa-big.dot", null, null));
            }
            time.start();
            dfa.minimize();
            time.stop();
            Out.time("Minimization took " + time);
            if (Out.DUMP) {
                Out.dump("Miniminal DFA is" + Out.NL + dfa);
            }
            if (Out.DOT) {
                dfa.writeDot(Emitter.normalize("dfa-min.dot", null, null));
            }
            time.start();
            Emitter e = new Emitter(inputFile, parser, dfa);
            e.emit();
            time.stop();
            Out.time("Writing took " + time);
            totalTime.stop();
            Out.time("Overall scanner generation time : " + totalTime);
        }
        catch (ScannerException e) {
            Out.error(e.file, e.message, e.line, e.column);
            throw new GeneratorException();
        }
        catch (MacroException e) {
            Out.error(e.getMessage());
            throw new GeneratorException();
        }
        catch (IOException e) {
            Out.error("An I/O-Error occured : " + e);
            throw new GeneratorException();
        }
        catch (OutOfMemoryError e) {
            Out.error(33);
            throw new GeneratorException();
        }
        catch (GeneratorException e) {
            throw new GeneratorException();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException();
        }
    }

    public static void setDir(String dirName) {
        File d = new File(dirName);
        if (d.isFile()) {
            Out.error("Error: \"" + d + "\" is not a directory.");
            throw new GeneratorException();
        }
        if (!d.isDirectory() && !d.mkdirs()) {
            Out.error("Error: couldn't create directory \"" + d + "\"");
            throw new GeneratorException();
        }
        Emitter.directory = d;
    }

    public static Vector parseOptions(String[] argv) {
        Vector<File> files = new Vector<File>();
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-d")) {
                if (++i >= argv.length) {
                    Out.error(30);
                    System.exit(1);
                }
                Main.setDir(argv[i]);
            } else if (argv[i].equals("--skel") || argv[i].equals("-skel")) {
                File skel;
                if (++i >= argv.length) {
                    Out.error(31);
                    System.exit(1);
                }
                if (!(skel = new File(argv[i])).isFile() || !skel.canRead()) {
                    Out.error("Error: couldn't open \"" + skel + "\".");
                    System.exit(1);
                }
                Skeleton.readSkelFile(skel);
            } else if (argv[i].equals("-v") || argv[i].equals("--verbose") || argv[i].equals("-verbose")) {
                Out.VERBOSE = true;
            } else if (argv[i].equals("-q") || argv[i].equals("--quiet") || argv[i].equals("-quiet")) {
                Out.VERBOSE = false;
            } else if (argv[i].equals("--dump") || argv[i].equals("-dump")) {
                Out.DUMP = true;
            } else if (argv[i].equals("--time") || argv[i].equals("-time")) {
                Out.TIME = true;
            } else {
                if (argv[i].equals("--version") || argv[i].equals("-version")) {
                    Out.println("This is JFlex 1.4_pre3");
                    System.exit(0);
                }
                if (argv[i].equals("--dot") || argv[i].equals("-dot")) {
                    Out.DOT = true;
                } else {
                    if (argv[i].equals("--help") || argv[i].equals("-h") || argv[i].equals("/h")) {
                        Main.printUsage();
                        System.exit(0);
                    }
                    if (argv[i].equals("--info") || argv[i].equals("-info")) {
                        Out.printSystemInfo();
                        System.exit(0);
                    }
                    if (argv[i].equals("--nomin") || argv[i].equals("-nomin")) {
                        no_minimize = true;
                    } else if (argv[i].equals("--pack") || argv[i].equals("-pack")) {
                        gen_method = 0;
                    } else if (argv[i].equals("--table") || argv[i].equals("-table")) {
                        gen_method = 1;
                    } else if (argv[i].equals("--switch") || argv[i].equals("-switch")) {
                        gen_method = 2;
                    } else if (argv[i].equals("--nobak") || argv[i].equals("-nobak")) {
                        no_backup = true;
                    } else {
                        File f;
                        if (argv[i].startsWith("-")) {
                            Out.error("Error: unknown option \"" + argv[i] + "\"");
                            Main.printUsage();
                            System.exit(1);
                        }
                        if ((f = new File(argv[i])).isFile() && f.canRead()) {
                            files.addElement(f);
                        } else {
                            Out.error("Sorry, couldn't open \"" + f + "\"");
                            throw new GeneratorException();
                        }
                    }
                }
            }
            ++i;
        }
        return files;
    }

    public static void printUsage() {
        Out.println("");
        Out.println("Usage: jflex <options> <input-files>");
        Out.println("");
        Out.println("Where <options> can be one or more of");
        Out.println("-d <directory>   write generated file to <directory>");
        Out.println("--skel <file>    use external skeleton <file>");
        Out.println("--switch");
        Out.println("--table");
        Out.println("--pack           set default code generation method");
        Out.println("--nomin          skip minimization step");
        Out.println("--nobak          don't create backup files");
        Out.println("--dump           display transition tables");
        Out.println("--dot            write graphviz .dot files for the generated automata (alpha)");
        Out.println("--verbose");
        Out.println("-v               display generation progress messages (default)");
        Out.println("--quiet");
        Out.println("-q               display errors only");
        Out.println("--time           display generation time statistics");
        Out.println("--version        print the version number of this copy of jflex");
        Out.println("--info           print system + JDK information");
        Out.println("--help");
        Out.println("-h               print this message");
        Out.println("");
        Out.println("This is JFlex 1.4_pre3");
        Out.println("Have a nice day!");
    }

    public static void generate(String[] argv) {
        Vector files = Main.parseOptions(argv);
        if (files.size() > 0) {
            int i = 0;
            while (i < files.size()) {
                Main.generate((File)files.elementAt(i));
                ++i;
            }
        } else {
            new MainFrame();
        }
    }

    public static void main(String[] argv) {
        try {
            Main.generate(argv);
        }
        catch (GeneratorException e) {
            Out.statistics();
            System.exit(1);
        }
    }
}

