/*
 * Decompiled with CFR 0.152.
 */
package javabook2;

import java.util.GregorianCalendar;
import javabook2.Format;

public class Clock {
    public static final int LONG_FORMAT = 0;
    public static final int SHORT_FORMAT = 1;
    public static final int TIME_12HR_FORMAT = 0;
    public static final int TIME_24HR_FORMAT = 1;
    private static final String[] MONTH_NAME = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private boolean clockRunning;
    private long totalElapsedTime;
    private long elapsedTime;
    private long startTime;
    private long stopTime;

    public Clock() {
        this.reset();
    }

    public String getCurrentDate() {
        return this.getCurrentDate(1);
    }

    public String getCurrentDate(int n) {
        String string = "";
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(1);
        switch (n) {
            case 0: {
                string = String.valueOf(MONTH_NAME[n2]) + " " + n3 + ", " + n4;
                break;
            }
            default: {
                string = String.valueOf(Format.rightAlign(2, n2 + 1)) + "/" + Format.rightAlign(2, n3) + "/" + n4;
            }
        }
        return string;
    }

    public String getCurrentTime() {
        return this.getCurrentTime(0);
    }

    public String getCurrentTime(int n) {
        String string;
        int n2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = gregorianCalendar.get(12);
        int n4 = gregorianCalendar.get(13);
        if (n == 0) {
            n2 = gregorianCalendar.get(10);
            string = gregorianCalendar.get(9) == 0 ? " AM" : " PM";
        } else {
            n2 = gregorianCalendar.get(11);
            string = "";
        }
        String string2 = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        String string3 = n3 < 10 ? "0" + n3 : String.valueOf(n3);
        String string4 = n4 < 10 ? "0" + n4 : String.valueOf(n4);
        String string5 = String.valueOf(string2) + ":" + string3 + ":" + string4 + " " + string;
        return string5;
    }

    public double getElapsedTime() {
        double d = this.clockRunning ? (double)(System.currentTimeMillis() - this.startTime) / 1000.0 : (double)this.elapsedTime / 1000.0;
        return d;
    }

    public double getTotalElapsedTime() {
        double d;
        if (this.clockRunning) {
            long l = System.currentTimeMillis();
            long l2 = this.totalElapsedTime + (l - this.startTime);
            d = (double)l2 / 1000.0;
        } else {
            d = (double)this.totalElapsedTime / 1000.0;
        }
        return d;
    }

    public void pause(double d) {
        long l = (long)(d * 1000.0);
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {}
    }

    public void reset() {
        this.clockRunning = false;
        this.totalElapsedTime = 0L;
    }

    public void start() {
        if (!this.clockRunning) {
            this.clockRunning = true;
            this.startTime = System.currentTimeMillis();
        }
    }

    public void stop() {
        if (this.clockRunning) {
            this.clockRunning = false;
            this.stopTime = System.currentTimeMillis();
            this.elapsedTime = this.stopTime - this.startTime;
            this.totalElapsedTime += this.elapsedTime;
        }
    }
}

