/*
 * Decompiled with CFR 0.152.
 */
package javabook2;

import java.awt.Frame;
import javabook2.JavaBookDialog;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputBox
extends JavaBookDialog {
    private static final String DEFAULT_TITLE = "Input Box";
    private JTextField inputLine;
    private JPanel contentPanel;

    public InputBox(Frame frame) {
        this(frame, true);
    }

    public InputBox(Frame frame, String string) {
        super(frame, true);
        this.setTitle(string);
        this.setIcon(3);
    }

    public InputBox(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle(DEFAULT_TITLE);
        this.setIcon(3);
    }

    private void createContentPanel(String string) {
        JLabel jLabel = new JLabel(string);
        this.inputLine = new JTextField(15);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.contentPanel.add(jLabel);
        this.contentPanel.add(this.inputLine);
    }

    public double getDouble() {
        return this.getFloat("Enter a double:");
    }

    public double getDouble(String string) {
        boolean bl = false;
        double d = 0.0;
        this.createContentPanel(string);
        do {
            String string2 = this.showDialog();
            try {
                d = Double.valueOf(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.getOwner(), "Not a valid double. Try again...", "Error", 0);
            }
        } while (!bl);
        return d;
    }

    public float getFloat() {
        return this.getFloat("Enter a float:");
    }

    public float getFloat(String string) {
        boolean bl = false;
        float f = 0.0f;
        this.createContentPanel(string);
        do {
            String string2 = this.showDialog();
            try {
                f = Float.valueOf(string2).floatValue();
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.getOwner(), "Not a valid float. Try again...", "Error", 0);
            }
        } while (!bl);
        return f;
    }

    public int getInteger() {
        return this.getInteger("Enter an integer:");
    }

    public int getInteger(String string) {
        boolean bl = false;
        int n = 0;
        this.createContentPanel(string);
        do {
            String string2 = this.showDialog();
            try {
                n = Integer.parseInt(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.getOwner(), "Not a valid integer. Try again...", "Error", 0);
            }
        } while (!bl);
        return n;
    }

    public String getString() {
        return this.getString("Enter a string:");
    }

    public String getString(String string) {
        this.createContentPanel(string);
        return this.showDialog();
    }

    private String showDialog() {
        JOptionPane.showOptionDialog(this.getOwner(), this.contentPanel, this.getTitle(), -1, this.getIcon(), null, new Object[]{"OK"}, null);
        return this.inputLine.getText();
    }
}

