/*
 * Decompiled with CFR 0.152.
 */
package javabook2;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.Vector;
import javabook2.JavaBookDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListBox
extends JavaBookDialog {
    public static final int NO_SELECTION = -1;
    public static final int CANCEL = -2;
    public static final String NO_ITEM = null;
    private static final String DEFAULT_TITLE = "List Box: Select One";
    private Vector items;
    private JPanel listPanel;
    private JList list;

    public ListBox(Frame frame) {
        this(frame, DEFAULT_TITLE, true);
    }

    public ListBox(Frame frame, String string) {
        this(frame, string, true);
    }

    public ListBox(Frame frame, String string, boolean bl) {
        super(frame, bl);
        this.setTitle(string);
        this.setIcon(3);
        this.items = new Vector();
    }

    public ListBox(Frame frame, boolean bl) {
        this(frame, DEFAULT_TITLE, bl);
    }

    public void addItem(String string) {
        this.items.addElement(string);
    }

    private void createListPanel() {
        this.list = new JList(this.items);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        this.listPanel = new JPanel();
        this.listPanel.add(jScrollPane);
    }

    public void deleteItem(int n) {
        this.items.removeElementAt(n);
    }

    public void deleteItem(String string) {
        this.items.removeElement(string);
    }

    public String getItemFromIndex(int n) {
        String string = null;
        if (n >= 0 && n < this.items.size()) {
            string = (String)this.items.elementAt(n);
        }
        return string;
    }

    public int getSelectedIndex() {
        this.createListPanel();
        int n = this.showDialog();
        return this.getSelectedIndex(n);
    }

    private int getSelectedIndex(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: {
                n2 = -2;
                break;
            }
            case 0: {
                n2 = this.list.getSelectedIndex();
                break;
            }
            default: {
                n2 = -2;
            }
        }
        return n2;
    }

    public String getSelectedItem() {
        int n = this.showDialog();
        int n2 = this.getSelectedIndex(n);
        return this.getItemFromIndex(n2);
    }

    private int showDialog() {
        return JOptionPane.showOptionDialog(this.getOwner(), this.listPanel, this.getTitle(), -1, this.getIcon(), null, new Object[]{"OK", "Cancel"}, null);
    }
}

