/*
 * Decompiled with CFR 0.152.
 */
package javabook2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class MainWindow
extends JFrame {
    private static final String CENTER_IMAGE_FILE = "../javabook2.gif";
    private static final String DEFAULT_TITLE = "Sample Java Application";
    private static final int HORIZONTAL_MARGIN = 40;
    private static final int VERTICAL_MARGIN = 80;
    private Dimension screenSize;

    public MainWindow() {
        this(DEFAULT_TITLE);
    }

    public MainWindow(String string) {
        super(string);
        this.initialize(true);
    }

    protected MainWindow(String string, boolean bl) {
        super(string);
        this.initialize(bl);
    }

    private void initialize(boolean bl) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.screenSize = toolkit.getScreenSize();
        ((Component)this).setSize(this.screenSize.width - 40, this.screenSize.height - 80);
        Container container = this.getContentPane();
        container.setBackground(Color.white);
        if (bl) {
            JLabel jLabel = new JLabel(new ImageIcon(CENTER_IMAGE_FILE));
            container.setLayout(new BorderLayout());
            container.add((Component)jLabel, "Center");
        }
        this.moveToCenter();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    protected void moveToCenter() {
        Dimension dimension = this.getSize();
        ((Component)this).setLocation((this.screenSize.width - dimension.width) / 2, (this.screenSize.height - dimension.height) / 2);
    }
}

