/*
 * Decompiled with CFR 0.152.
 */
package javabook2;

import java.awt.Frame;
import java.awt.GridLayout;
import javabook2.JavaBookDialog;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MultiInputBox
extends JavaBookDialog {
    public static final String[] NO_ITEM = null;
    private static final String DEFAULT_TITLE = "MultiInput Box";
    private static final int CANCEL = -2;
    private static final int OK = 0;
    private int status;
    private JTextField[] inputLine;
    private JLabel[] prompt;
    private JPanel contentPanel;
    private int numOfRows;
    private boolean resetInputLine;

    public MultiInputBox(Frame frame, int n) {
        super(frame, true);
        this.setTitle(DEFAULT_TITLE);
        this.setIcon(3);
        this.numOfRows = n;
        this.prompt = new JLabel[this.numOfRows];
        this.inputLine = new JTextField[this.numOfRows];
        int n2 = 0;
        while (n2 < this.numOfRows) {
            this.prompt[n2] = new JLabel("");
            this.inputLine[n2] = new JTextField(15);
            ++n2;
        }
        this.setDialogState(0);
        this.setResetOption(false);
    }

    public MultiInputBox(Frame frame, String[] stringArray) {
        this(frame, stringArray.length);
        this.setLabels(stringArray);
    }

    private void clearInputLines() {
        int n = 0;
        while (n < this.numOfRows) {
            this.inputLine[n].setText("");
            ++n;
        }
    }

    private void createContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        int n = 0;
        while (n < this.numOfRows) {
            jPanel.add(this.prompt[n]);
            jPanel2.add(this.inputLine[n]);
            ++n;
        }
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.contentPanel.add(jPanel);
        this.contentPanel.add(jPanel2);
    }

    private String[] getInputLines(int n) {
        String[] stringArray = new String[this.numOfRows];
        switch (n) {
            case -1: 
            case 1: {
                this.setDialogState(-2);
                stringArray = null;
                break;
            }
            case 0: {
                int n2 = 0;
                while (n2 < this.numOfRows) {
                    stringArray[n2] = this.inputLine[n2].getText();
                    ++n2;
                }
                this.setDialogState(0);
                break;
            }
            default: {
                stringArray = null;
                this.setDialogState(-2);
            }
        }
        return stringArray;
    }

    public String[] getInputs() {
        if (this.contentPanel == null) {
            this.createContentPanel();
        }
        int n = this.showDialog();
        String[] stringArray = this.getInputLines(n);
        if (this.resetInputLine) {
            this.clearInputLines();
        }
        return stringArray;
    }

    public boolean isCanceled() {
        return this.status == -2;
    }

    private void setDialogState(int n) {
        this.status = n;
    }

    public void setLabels(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.prompt[n].setText(stringArray[n]);
            ++n;
        }
    }

    public void setResetOption(boolean bl) {
        this.resetInputLine = bl;
    }

    public void setValue(int n, String string) {
        if (n >= 0 && n < this.numOfRows) {
            this.inputLine[n].setText(string);
        }
    }

    private int showDialog() {
        return JOptionPane.showOptionDialog(this.getOwner(), this.contentPanel, this.getTitle(), -1, this.getIcon(), null, new Object[]{"OK", "Cancel"}, null);
    }
}

