/*
 * Decompiled with CFR 0.152.
 */
package javabook2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JTextArea;

public class OutputBox
extends JDialog {
    private static final String DEFAULT_TITLE = "Program Output";
    private static final int DEFAULT_WIDTH = 550;
    private static final int DEFAULT_HEIGHT = 380;
    private static final int MAX_SKIPLINE = 21;
    private static Font font;
    private static String newLine;
    private JTextArea outputArea;

    static {
        newLine = System.getProperty("line.separator");
        font = new Font("Courier", 0, 12);
    }

    public OutputBox(Frame frame) {
        this(frame, DEFAULT_TITLE);
    }

    public OutputBox(Frame frame, int n, int n2) {
        this(frame, n, n2, DEFAULT_TITLE);
    }

    public OutputBox(Frame frame, int n, int n2, String string) {
        super(frame, false);
        this.initialize(n, n2, string);
    }

    public OutputBox(Frame frame, String string) {
        this(frame, 550, 380, string);
    }

    public void appendToFile(String string) {
        this.writeToFile(string, true);
    }

    public void clear() {
        this.outputArea.setText("");
    }

    private void initialize(int n, int n2, String string) {
        this.setResizable(true);
        this.setTitle(string);
        this.setFont(font);
        this.outputArea = new JTextArea();
        this.setContentPane(this.outputArea);
        ((Component)this).setSize(n, n2);
        this.moveToCenter();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OutputBox.this.dispose();
                OutputBox.this.setModal(false);
            }
        });
    }

    private void moveToCenter() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void newLine() {
        this.outputArea.append(newLine);
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(String string) {
        this.outputArea.append(string);
    }

    public void print(StringBuffer stringBuffer) {
        this.print(stringBuffer.toString());
    }

    public void print(boolean bl) {
        this.print(String.valueOf(bl));
    }

    public void printLine(char c) {
        this.printLine(String.valueOf(c));
    }

    public void printLine(double d) {
        this.printLine(String.valueOf(d));
    }

    public void printLine(long l) {
        this.printLine(String.valueOf(l));
    }

    public void printLine(String string) {
        this.print(string);
        this.newLine();
    }

    public void printLine(StringBuffer stringBuffer) {
        this.printLine(stringBuffer.toString());
    }

    public void printLine(boolean bl) {
        this.printLine(String.valueOf(bl));
    }

    public void saveToFile(String string) {
        this.writeToFile(string, false);
    }

    public void setFont(Font font) {
        if (this.outputArea != null) {
            this.outputArea.setFont(font);
        }
        OutputBox.font = font;
    }

    public void skipLine(int n) {
        if (n > 0 && n < 21) {
            int n2 = 0;
            while (n2 < n) {
                this.newLine();
                ++n2;
            }
        }
    }

    public void waitUntilClose() {
        ((Component)this).setVisible(false);
        this.setModal(true);
        ((Component)this).setVisible(true);
    }

    private void writeToFile(String string, boolean bl) {
        try {
            FileWriter fileWriter = new FileWriter(string, bl);
            fileWriter.write(this.outputArea.getText());
            fileWriter.close();
        }
        catch (IOException iOException) {}
    }
}

