/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class Tank
extends Frame
implements WindowListener {
    private static final int TANK_BUFFER = 2;
    public static final int TANK_WIDTH = 25;
    private static final int ACTUAL_TANK_WIDTH = 27;
    public static final int TANK_HEIGHT = 17;
    private static final int ACTUAL_TANK_HEIGHT = 19;
    public static final int WATER_HEIGHT = 15;
    private static final int AIR_HEIGHT = 2;
    public static final int FOOD_CENTER_POINTS = 99;
    public static final int FISH_MAX_POINTS = 200;
    public static final int PIRANHA_MAX_POINTS = 300;
    public static final int FISH_MOVE_COST = 1;
    public static final int PIRANHA_MOVE_COST = 2;
    public static final double STRENGTH_THRESHOLD = 0.5;
    public static final double HUNGER_THRESHOLD = 0.75;
    public static final boolean RIGHT = true;
    public static final boolean LEFT = false;
    private static final int SCALE_FACTOR = 2;
    private static final int CELL_WIDTH = 16;
    private static final int CELL_HEIGHT = 16;
    private static final int BORDER_SIZE = 2;
    private static final int PIXELS_ACROSS = 496;
    private static final int PIXELS_DOWN = 368;
    private static final long SLEEP_TIME = 400L;
    private Canvas tank;
    private Graphics showPage;
    private Graphics drawPage;
    private Image bufferedImage;
    private boolean outOfWater = false;
    private Vector fishVector;
    private Vector foodCentersVector;
    private Vector piranhaVector;

    public Tank() {
        super("Aquarium Simulation");
        this.setLocation(20, 20);
        this.tank = new Canvas();
        this.tank.setSize(496, 368);
        this.add(this.tank);
        this.pack();
        this.showPage = this.tank.getGraphics();
        this.bufferedImage = this.createImage(this.getSize().width, this.getSize().height);
        this.drawPage = this.bufferedImage.getGraphics();
        this.fishVector = new Vector();
        this.foodCentersVector = new Vector();
        this.piranhaVector = new Vector();
        this.addWindowListener(this);
        this.setVisible(true);
    }

    public void addFish(Fish fish) {
        this.fishVector.addElement(fish);
    }

    public void addPiranha(Piranha piranha) {
        this.piranhaVector.addElement(piranha);
    }

    public void addFoodCenter(FoodCenter foodCenter) {
        this.foodCentersVector.addElement(foodCenter);
    }

    public FishList getFishList() {
        return new FishList(this.fishVector);
    }

    public PiranhaList getPiranhaList() {
        return new PiranhaList(this.piranhaVector);
    }

    public FoodCentersList getFoodCentersList() {
        return new FoodCentersList(this.foodCentersVector);
    }

    public void refreshDisplay() {
        FoodCenter foodCenter;
        int n;
        this.bufferedImage = this.createImage(this.getSize().width, this.getSize().height);
        this.drawPage = this.bufferedImage.getGraphics();
        this.drawTank();
        for (n = 0; n < this.foodCentersVector.size(); ++n) {
            foodCenter = (FoodCenter)this.foodCentersVector.elementAt(n);
            this.drawFoodCenter(foodCenter);
        }
        for (n = 0; n < this.fishVector.size(); ++n) {
            foodCenter = (Fish)this.fishVector.elementAt(n);
            if (foodCenter.isDead()) continue;
            this.drawFish((Fish)foodCenter);
        }
        for (n = 0; n < this.piranhaVector.size(); ++n) {
            foodCenter = (Piranha)this.piranhaVector.elementAt(n);
            if (foodCenter.isDead()) continue;
            this.drawPiranha((Piranha)foodCenter);
        }
        this.drawPage.dispose();
        this.showPage.drawImage(this.bufferedImage, 0, 0, null);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void drawTank() {
        this.drawPage.setColor(Color.white);
        this.drawPage.fillRect(0, 0, 496, 368);
        this.drawPage.setColor(Color.black);
        this.drawPage.fillRect(29, 29, 438, 310);
        this.drawPage.setColor(Color.white);
        this.drawPage.fillRect(32, 32, 432, 32);
        this.drawPage.setColor(Color.blue);
        this.drawPage.fillRect(32, 64, 432, 272);
    }

    private void drawEmptyTank() {
        this.drawPage.setColor(Color.black);
        this.drawPage.fillRect(29, 29, 438, 310);
        this.drawPage.setColor(Color.red);
        this.drawPage.fillRect(32, 32, 432, 304);
    }

    private void drawFoodCenter(FoodCenter foodCenter) {
        Location location = foodCenter.getLocation();
        int n = location.getX();
        int n2 = location.getY();
        this.checkLocation("A food center", n, n2);
        int n3 = (n + 2) * 16;
        int n4 = (n2 + 2 + 2) * 16;
        this.drawPage.setColor(foodCenter.getColor());
        this.drawPage.fillRect(n3, n4, 16, 16);
        this.drawPage.setColor(Color.black);
        this.drawPage.drawString("" + foodCenter.getFoodPoints(), n3, n4 + 16);
    }

    private void drawFish(Fish fish) {
        this.drawFish(fish.getLocation().getX(), fish.getLocation().getY(), fish.getDirection(), fish.getColor(), fish.getFoodPoints());
    }

    private void drawFish(int n, int n2, boolean bl, Color color, int n3) {
        int n4;
        this.checkLocation("The Fish ", n, n2);
        int n5 = (n + 2) * 16;
        int n6 = (n2 + 2 + 2) * 16;
        int[] nArray = new int[]{1, 4, 4, 5, 7, 9, 11, 13, 15, 16, 16, 10, 7, 8, 7, 6, 4, 1, 2};
        int[] nArray2 = new int[]{2, 4, 2, 4, 4, 2, 4, 4, 5, 7, 8, 9, 12, 9, 8, 9, 6, 8, 5};
        int n7 = nArray.length;
        int[] nArray3 = new int[n7];
        int[] nArray4 = new int[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            nArray3[n4] = bl ? n5 + nArray[n4] * 2 : n5 + (16 - nArray[n4]) * 2;
            nArray4[n4] = n6 + nArray2[n4] * 2;
        }
        this.drawPage.setColor(color);
        this.drawPage.fillPolygon(new Polygon(nArray3, nArray4, n7));
        this.drawPage.drawString(" " + n3, n5 + 10, n6 + 33);
        if (color.getBlue() >= 64 && color.getRed() <= 64) {
            this.drawPage.setColor(Color.white);
        } else {
            this.drawPage.setColor(Color.black);
        }
        n4 = 0;
        if (bl) {
            n4 = 10;
        }
        this.drawPage.fillOval(n5 + (n4 + 3) * 2, n6 + 12, 2, 2);
        this.drawPage.drawPolygon(new Polygon(nArray3, nArray4, n7));
    }

    private void drawPiranha(Piranha piranha) {
        this.drawPiranha(piranha.getLocation().getX(), piranha.getLocation().getY(), piranha.getDirection(), piranha.getColor(), piranha.getFoodPoints());
    }

    private void drawPiranha(int n, int n2, boolean bl, Color color, int n3) {
        int n4;
        this.checkLocation("The Piranha ", n, n2);
        int n5 = (n + 2) * 16;
        int n6 = (n2 + 2 + 2) * 16;
        int[] nArray = new int[]{1, 4, 4, 5, 7, 6, 10, 11, 14, 16, 15, 15, 14, 14, 13, 14, 14, 15, 15, 16, 16, 12, 11, 8, 9, 6, 5, 5, 4, 1, 2};
        int[] nArray2 = new int[]{1, 4, 2, 3, 2, 1, 1, 2, 2, 6, 7, 6, 7, 6, 7, 8, 7, 8, 7, 8, 9, 10, 11, 11, 10, 9, 10, 9, 7, 9, 5};
        int n7 = nArray.length;
        int[] nArray3 = new int[n7];
        int[] nArray4 = new int[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            nArray3[n4] = bl ? n5 + nArray[n4] * 2 : n5 + (16 - nArray[n4]) * 2;
            nArray4[n4] = n6 + nArray2[n4] * 2;
        }
        this.drawPage.setColor(color);
        this.drawPage.fillPolygon(new Polygon(nArray3, nArray4, n7));
        this.drawPage.setColor(Color.black);
        this.drawPage.drawString(" " + n3, n5, n6 + 33);
        this.drawPage.setColor(Color.red);
        n4 = 0;
        if (bl) {
            n4 = 10;
        }
        this.drawPage.fillOval(n5 + (n4 + 3) * 2, n6 + 6, 2, 2);
        this.drawPage.setColor(Color.black);
        this.drawPage.drawPolygon(new Polygon(nArray3, nArray4, n7));
    }

    private void checkLocation(String string, int n, int n2) {
        if (n < 0 || n > 25 || n2 < 0 || n2 > 15) {
            this.outOfWater = true;
            this.bufferedImage = this.createImage(this.getSize().width, this.getSize().height);
            this.drawPage = this.bufferedImage.getGraphics();
            this.drawEmptyTank();
            this.drawPage.setColor(Color.white);
            this.drawPage.drawString(string + " is a out of the water at (" + n + ", " + n2 + ")", 75, 75);
            this.drawPage.dispose();
            this.showPage.drawImage(this.bufferedImage, 0, 0, null);
            throw new OutOfWaterException(string, n, n2);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this.outOfWater) {
            this.refreshDisplay();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

