
#ifndef NBODYTYPES_H
#define NBODYTYPES_H

class DoubleVector {
public:
  double x;
  double y;
  DoubleVector() 
    : x(0.0), y(0.0)
  {}
  DoubleVector(double _x, double _y)
    : x(_x), y(_y)
  {}
  DoubleVector(const DoubleVector& v) {
    this->x = v.x;
    this->y = v.y;
  }
  DoubleVector& operator=(const DoubleVector& v) { 
    if (this != &v){
      this->x = v.x;
      this->y = v.y;
    }
    return *this; 
  }
};

typedef DoubleVector Point;

struct PointMass {
  Point center_of_mass;
  double mass;
};

struct Body {
  PointMass point_mass;
  DoubleVector veloc;
};

class Rectangle {
public:

  class InvalidRectangleException {

  };

  Rectangle(Point upper_left, Point lower_right) 
    : m_upper_left(upper_left), m_lower_right(lower_right)
  { 
    if (!isValid()) {
      throw InvalidRectangleException();
    } 
  }
  
  bool isValid() {
    if (m_upper_left.x > m_lower_right.x) { return false; }
    if (m_upper_left.y < m_lower_right.y) { return false; }
    return true;
  }

  bool contains(Point p) {
    if ((m_upper_left.x <= p.x && m_lower_right.x > p.x) &&
        (m_upper_left.y > p.y && m_lower_right.y <= p.y))
      return true;
    return false;
  }

  double area() {
    return (m_lower_right.x - m_upper_left.x)*(m_upper_left.y - m_lower_right.y);
  }

  Point middle() {
    return Point(m_upper_left.x + (m_lower_right.x - m_upper_left.x)/2, 
		 m_lower_right.y + (m_upper_left.y - m_lower_right.y)/2);
  }
  Point upperLeftCorner() {
    return m_upper_left;
  }
  Point lowerRightCorner() {
    return m_lower_right;
  }
private:
  Point m_upper_left;
  Point m_lower_right;
};

#endif
