
#include <stdio.h>

#include "SerialQTreeSimulator.h"
#include "QTree.h"

void SerialQTreeSimulator::simulate(int timesteps, double delta)
{
  double total_accel_x, total_accel_y;
  double d, d_x, d_y, f, f_x, f_y;

  for(int i=0;i<timesteps;i++){

    QTree root;
    root.build(m_bodies, m_num_bodies, 
	       m_universe_min_x, m_universe_max_x, 
               m_universe_min_y, m_universe_max_y);

    /* the first half of the timestep..calculate forces and accelerations */
    DoubleVector accel;
    for(int j=0;j<m_num_bodies;j++){
      DoubleVector force(root.calculateForce(&m_bodies[j]));
      /*
      printf("force on %f %f: %f %f\n", m_bodies[j].point_mass.center_of_mass.x,
             m_bodies[j].point_mass.center_of_mass.y,
             force.x, force.y);
      */      
      accel.x = force.x / m_bodies[j].point_mass.mass;
      accel.y = force.y / m_bodies[j].point_mass.mass;
      m_bodies[j].veloc.x += delta * accel.x;
      m_bodies[j].veloc.y += delta * accel.y;
    }

    /* now complete the timestep and update positions */
    for(int l=0;l<m_num_bodies;l++){
      m_bodies[l].point_mass.center_of_mass.x += delta * m_bodies[l].veloc.x;
      if (m_bodies[l].point_mass.center_of_mass.x < m_universe_min_x)
	m_universe_min_x = m_bodies[l].point_mass.center_of_mass.x;
      if (m_bodies[l].point_mass.center_of_mass.x > m_universe_max_x)
	m_universe_max_x = m_bodies[l].point_mass.center_of_mass.x;
      m_bodies[l].point_mass.center_of_mass.y += delta * m_bodies[l].veloc.y;
      if (m_bodies[l].point_mass.center_of_mass.y < m_universe_min_y)
	m_universe_min_y = m_bodies[l].point_mass.center_of_mass.y;
      if (m_bodies[l].point_mass.center_of_mass.y > m_universe_max_y)
	m_universe_max_y = m_bodies[l].point_mass.center_of_mass.y;
    }
  }

}
