
#include <math.h>
#include <stdio.h>

#include "SerialPairwiseSimulator.h"


#define G (6.67e-11) // gravitational constant

void SerialPairwiseSimulator::simulate(int timesteps, double delta)
{
  double total_accel_x, total_accel_y;
  double d, d_x, d_y, f, f_x, f_y;
  for(int i=0;i<timesteps;i++){

    /* the first half of the timestep..calculate forces and accelerations */
    for(int j=0;j<m_num_bodies;j++){
      total_accel_x = 0;
      total_accel_y = 0;
      for(int k=0;k<m_num_bodies;k++){
        if(k==j) continue;

        // first, calculate the distance between the two bodies
        d_x = m_bodies[k].point_mass.center_of_mass.x - m_bodies[j].point_mass.center_of_mass.x;
        d_y = m_bodies[k].point_mass.center_of_mass.y - m_bodies[j].point_mass.center_of_mass.y;
        d = sqrt(d_x * d_x + d_y * d_y);
        
        // then the component forces
        DoubleVector force(0.0, 0.0);
        f = (G * m_bodies[j].point_mass.mass * m_bodies[k].point_mass.mass) / (d * d);
        force.x += f * (d_x / d);
        force.y += f * (d_y / d);
        total_accel_x += force.x / m_bodies[j].point_mass.mass;
        total_accel_y += force.y / m_bodies[j].point_mass.mass;
      
      }
      /*
      printf("force on %f %f: %f %f\n", m_bodies[j].point_mass.center_of_mass.x,
             m_bodies[j].point_mass.center_of_mass.y,
             force.x, force.y);
      */

      m_bodies[j].veloc.x += delta * total_accel_x;
      m_bodies[j].veloc.y += delta * total_accel_y;
    }

    /* now complete the timestep and update positions */
    for(int l=0;l<m_num_bodies;l++){
      m_bodies[l].point_mass.center_of_mass.x += delta * m_bodies[l].veloc.x;
      m_bodies[l].point_mass.center_of_mass.y += delta * m_bodies[l].veloc.y;
    }
  }
}
