#ifndef STATS_H
#define STATS_H

#include <pthread.h>
#include <time.h>
using namespace std;

extern pthread_mutex_t statslock;

#define INCREMENT_STAT( name ) { pthread_mutex_lock( &statslock ); name++; pthread_mutex_unlock( &statslock ); }

extern int nScans;
extern int nUpdates;
extern int nLookups;
extern int nCAdds;
extern int nCRemoves;

extern int nScanAborts;
extern int nUpdateAborts;
extern int nLookupAborts;
extern int nCAddAborts;
extern int nCRemoveAborts;

extern struct timeval starttime;
extern struct timeval endtime;

extern int nAborts;
extern int nCommits;

void clearStats();
void printStats();

#endif

