#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <assert.h>

#define BLOCKSIZE (4096)

void
check(char *buffer, int value)
{
    int bad = 0;
    int *p = (int *) buffer;
    for (int i = 0; i < (BLOCKSIZE / sizeof(int)); i++) {
	if (*p != value) 
	    bad++;
    }
    if (bad)
	fprintf(stderr, "BAD BLOCK: value should be %d but wasn't\n", value);
}

int main(int argc, char *argv[])
{
    if (argc != 2) {
	fprintf(stderr, "usage: check <filename>\n"); exit(1);
    } 
    char *file = argv[1];
    
    int fd = open(file, O_RDONLY);
    char buffer[BLOCKSIZE];	
    int i = 0;
    int rc;
    while ((rc = read(fd, buffer, BLOCKSIZE)) > 0) {
	assert(rc == BLOCKSIZE); 
	check(buffer, i);
	i++;
    }
    (void) close(fd);
    
    return 0;
}

