#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <assert.h>

#define BLOCKSIZE (4096)

void
corrupt(char *buffer)
{
    int *p = (int *) buffer;
    for (int i = 0; i < (BLOCKSIZE / sizeof(int)); i++) {
	*p = 123456;
	p++;
    }
}

int main(int argc, char *argv[])
{
    if (argc != 3) {
	fprintf(stderr, "usage: corrupt <filename> <block to corrupt>\n"); exit(1);
    } 
    char *file = argv[1];
    int block  = atoi(argv[2]);
    
    int fd = open(file, O_WRONLY); assert(fd > -1);
    int rc = lseek(fd, block * BLOCKSIZE, SEEK_SET);
    assert(rc == (block * BLOCKSIZE));
    char buffer[BLOCKSIZE];
    corrupt(buffer);
    rc = write(fd, buffer, BLOCKSIZE); assert(rc == BLOCKSIZE);
    (void) close(fd);
    
    return 0;
}

