#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <assert.h>

#define BLOCKSIZE (4096)

void
fill(char *buffer, int value)
{
    int *p = (int *) buffer;
    for (int i = 0; i < (BLOCKSIZE / sizeof(int)); i++) {
	*p = value;
	p++;
    }
}

int main(int argc, char *argv[])
{
    if (argc != 3) {
	fprintf(stderr, "usage: gen <filename> <number of blocks>\n"); exit(1);
    } 
    char *file = argv[1];
    int blocks = atoi(argv[2]);
    
    int fd = open(file, O_WRONLY | O_CREAT | O_TRUNC, 0666); assert(fd > -1);
    for (int i = 0; i < blocks; i++) {
	char buffer[BLOCKSIZE];
	fill(buffer, i);
	int rc = write(fd, buffer, BLOCKSIZE); assert(rc == BLOCKSIZE);
    }
    (void) close(fd);
    
    return 0;
}

