#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdarg.h>
#include <assert.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <dlfcn.h>

void fs_init() __attribute__((constructor));
void fs_fini() __attribute__((destructor));

static void *handle = NULL;

typedef struct __syscall {
    int (*open)(const char *, int); 
    int (*close)(int); 
    ssize_t (*read)(int, void *, size_t);
} syscall_t;

syscall_t *stable;

void fs_init()
{
    // get handle to libc
    handle = dlopen("/lib/libc.so.6",  RTLD_LAZY);
    assert(handle != NULL);

    // set up syscall table
    stable = (syscall_t *) malloc(sizeof(syscall_t));
    assert(stable != NULL);
    stable->open     = (int(*)(const char *, int)) dlsym(handle, "open");
    stable->close    = (int(*)(int)) dlsym(handle, "close");
    stable->read     = (ssize_t(*)(int, void *, size_t)) dlsym(handle, "read");
}

void fs_fini()
{
    free(stable);
    dlclose(handle);
}

// example of how to use the stable
ssize_t 
read(int fd, void *buf, size_t count)
{
    return (*stable->read)(fd, buf, count);
}

