/* DEM */
/* functions sf2c creates that we don't want macro-expanded */

#include <varargs.h>
#include "sf2c.h"

/* MIN functions */
integer i_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	integer best,temp,i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,integer);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,integer);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

shortint h_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	shortint best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,shortint);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,shortint);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

real r_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	real best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,real);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,real);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

doublereal d_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	doublereal best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,doublereal);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,doublereal);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

real ri_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	real best;
	integer temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,integer);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,integer);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

doublereal di_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	doublereal best;
	integer temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,integer);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,integer);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

integer ir_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	real best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,real);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,real);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

integer id_min(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	doublereal best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,doublereal);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,doublereal);
		if (temp < best) best = temp;
	}
	
	va_end(ap);
	return best;
}

/* MAX functions */
integer i_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	integer best,temp,i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,integer);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,integer);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}

shortint h_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	shortint best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,shortint);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,shortint);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}

real r_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	real best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,real);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,real);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}

doublereal d_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	doublereal best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,doublereal);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,doublereal);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}

real ri_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	real best;
	integer temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,integer);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,integer);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}

doublereal di_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	doublereal best;
	integer temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,integer);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,integer);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}

integer ir_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	real best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,real);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,real);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}

integer id_max(va_alist)
va_dcl
{
	va_list ap;
	long num_args;
	doublereal best,temp;
	integer i;

	va_start(ap);
	
	num_args = va_arg(ap,long);
	best = va_arg(ap,doublereal);
	for (i=2; i<=num_args; i++) {
		temp = va_arg(ap,doublereal);
		if (temp > best) best = temp;
	}
	
	va_end(ap);
	return best;
}


/* ABS functions */

double sd_abs(x)
doublereal x;
{
if(x >= 0)
	return(x);
return(- x);
}

double sc_abs(z)
complex *z;
{
return sqrt((z->_r * z->_r) + (z->_i * z->_i));
}

double sr_abs(x)
real x;
{
if(x >= 0)
	return(x);
return(- x);
}

double sz_abs(z)
doublecomplex *z;
{
return sqrt((z->_r * z->_r) + (z->_i * z->_i));
}

integer si_abs(x)
integer x;
{
if(x >= 0)
	return(x);
return(- x);
}

shortint sh_abs(x)
shortint x;
{
if(x >= 0)
	return(x);
return(- x);
}
