/*  Association List Definitions */

/*  Copyright (c) 1994 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#ifdef SUIFLIB
#include "suif_copyright.h"
#else
#include <suif/suif_copyright.h>
#endif

#ifndef ALIST_H
#define ALIST_H

#pragma interface

RCS_HEADER(alist_h,
    "$Id: alist.h,v 4.5 1996/02/16 04:20:35 cwilson Exp $")

/*
 *  Association list elements include both a key and a data pointer.
 *  This allows access to a particular list element specified by a key.
 */

class alist_e : public glist_e {
public:
    void *key, *info;

    alist_e(void *k, void *i) 		{ key = k; info = i; }
    alist_e *next()			{ return (alist_e *)glist_e::next(); }
};


/*
 *  The alist class defines several functions to search for a
 *  particular key and return either the list element or the info
 *  pointer from that element.  Several wrapper function also provide
 *  type-correct access to the underlying glist functions.
 */

class alist : public glist {
public:
    alist_e *head() const		{ return (alist_e *)glist::head(); }
    alist_e *tail() const		{ return (alist_e *)glist::tail(); }
    alist_e *push(alist_e *e)		{ return (alist_e *)glist::push(e); }
    alist_e *pop()			{ return (alist_e *)glist::pop(); }
    alist_e *remove(alist_e *e)		{ return (alist_e *)glist::remove(e); }

    alist_e *enter(void *k, void *i)	{ return push(new alist_e(k, i)); }
    alist_e *search(void *k) const;
    void *lookup(void *k) const;
    boolean exists(void *k, void **i = NULL) const;
};


/*
 *  The amtflist class combines the features of the association lists
 *  with those of the move-to-front lists.  The interface is equivalent
 *  to the alist interface.
 */

class amtflist : public mtflist {
public:
    alist_e *head()			{ return (alist_e*)mtflist::head(); }
    alist_e *tail()			{ return (alist_e*)mtflist::tail(); }
    alist_e *push(alist_e *e)		{ return (alist_e*)mtflist::push(e); }
    alist_e *pop()			{ return (alist_e*)mtflist::pop(); }
    alist_e *remove(alist_e *e)		{ return (alist_e*)mtflist::remove(e);}

    alist_e *enter(void *k, void *i)	{ return push(new alist_e(k, i)); }
    alist_e *search(void *k);
    void *lookup(void *k);
    boolean exists(void *k, void **i = NULL);
};


/*
 *  This iterator works for both alists and amtflists.
 */

class alist_iter : public glist_iter {
public:
    alist_iter()			{ }
    alist_iter(const alist *l)		{ reset(l); }
    alist_iter(const amtflist *l)	{ reset(l); }

    alist_e *step()		{ return (alist_e *)glist_iter::step(); }
    alist_e *peek()		{ return (alist_e *)glist_iter::peek(); }
    alist_e *cur_elem()		{ return (alist_e *)glist_iter::cur_elem(); }
};

#endif /* ALIST_H */
