/*  Library Initialization */

/*  Copyright (c) 1994 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#ifdef SUIFLIB
#include "suif_copyright.h"
#else
#include <suif/suif_copyright.h>
#endif

#ifndef INITSUIF_H
#define INITSUIF_H

#pragma interface

RCS_HEADER(initsuif_h,
    "$Id: initsuif.h,v 1.8 1995/10/17 23:20:41 cwilson Exp $")

/*
 *  Library initialization.  For the SUIF library to be able to print the
 *  version numbers for all the libraries linked in a particular program,
 *  it needs to know which libraries are included.  Thus, the user must
 *  register each library (using the "register_library" function) before
 *  calling "init_suif".  The library records the information for the
 *  registered libraries in a list of "suif_library" structures.  The
 *  "start_suif" function declared here may be automatically generated
 *  by the makefiles to register the appropriate libraries.
 */

typedef void (*lib_init_f)(int& argc, char *argv[]);
typedef void (*lib_exit_f)();

struct suif_library {
    char *name;				/* name of the library (e.g. "suif") */
    char *version;			/* the library version */
    char *compile_info;			/* who/when/where was it compiled */
    lib_init_f initializer;		/* function to initialize it */
    lib_exit_f finalizer;		/* function to deallocate storage */
};

DECLARE_DLIST_CLASS(library_list, suif_library*);
extern library_list *suif_libraries;	/* list of registered libraries */

void register_library(char *nm, char *ver, char *info,
		      lib_init_f init_f=NULL,
		      lib_exit_f exit_f=NULL);
void start_suif(int& argc, char *argv[]);
void init_suif(int& argc, char *argv[]);
void exit_suif();

#define LIBRARY(name, init_f, exit_f) \
    extern char *lib ## name ## _ver_string; \
    extern char *lib ## name ## _who_string; \
    extern void init_f(int& argc, char *argv[]); \
    extern void exit_f(); \
    register_library(#name, lib ## name ## _ver_string, \
		     lib ## name ## _who_string, init_f, exit_f)

/* these variables are linked in by the standard Makefiles */
extern char *prog_ver_string;		/* program version, e.g. "2.4" */
extern char *prog_who_string;		/* who, when, where compiled/linked */
extern char *prog_suif_string;		/* SUIF distribution version */
extern char *libsuif_ver_string;
extern char *libsuif_who_string;
extern char *libsuif_suif_string;

#endif /* INITSUIF_H */
