/* file "ptr_index.h" */

/*  Copyright (c) 1995 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#ifdef SUIFLIB
#include "suif_copyright.h"
#else
#include <suif/suif_copyright.h>
#endif

#ifndef PTR_INDEX_H
#define PTR_INDEX_H

#pragma interface

RCS_HEADER(ptr_index_h,
    "$Id: ptr_index.h,v 1.1 1995/10/17 23:20:41 cwilson Exp $")


class ptr_index
  {
protected:
    ptr_index(void)  { }

    si_entry *create_entry(void *init_data)
      { return new si_entry(init_data); }
    void destroy_entry(si_entry *old_entry)  { delete old_entry; }
    void *get_back_pointer(si_entry *the_entry)
      { return the_entry->back_pointer; }
    void set_back_pointer(si_entry *the_entry, void *new_value)
      { the_entry->back_pointer = new_value; }

public:
    virtual ~ptr_index(void)  { }

    virtual si_entry *enter(void *the_ptr, void *the_data = NULL) = 0;
    virtual si_entry *lookup_entry(void *the_ptr) = 0;
    virtual boolean exists(void *the_ptr) = 0;
    virtual void *lookup(void *the_ptr) = 0;
    virtual void remove_entry(si_entry *the_entry) = 0;
  };

#endif /* PTR_INDEX_H */
