/* file "string_index.h" */

/*  Copyright (c) 1995 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#ifdef SUIFLIB
#include "suif_copyright.h"
#else
#include <suif/suif_copyright.h>
#endif

#ifndef STRING_INDEX_H
#define STRING_INDEX_H

#pragma interface

RCS_HEADER(string_index_h,
    "$Id: string_index.h,v 1.1 1995/10/17 23:20:41 cwilson Exp $")


class si_entry
  {
    friend class string_index;
    friend class ptr_index;

private:
    void *the_data;
    void *back_pointer;

    si_entry(void *init_data)  { the_data = init_data; back_pointer = NULL; }
    ~si_entry(void)  { }

public:
    void *data_value(void)  { return the_data; }
  };

class string_index
  {
protected:
    string_index(void)  { }

    si_entry *create_entry(void *init_data)
      { return new si_entry(init_data); }
    void destroy_entry(si_entry *old_entry)  { delete old_entry; }
    void *get_back_pointer(si_entry *the_entry)
      { return the_entry->back_pointer; }
    void set_back_pointer(si_entry *the_entry, void *new_value)
      { the_entry->back_pointer = new_value; }

public:
    virtual ~string_index(void)  { }

    virtual si_entry *enter(char *the_string, void *the_data = NULL) = 0;
    virtual si_entry *lookup_entry(char *the_string) = 0;
    virtual boolean exists(char *the_string) = 0;
    virtual void *lookup(char *the_string) = 0;
    virtual void remove_entry(si_entry *the_entry) = 0;
  };

#endif /* STRING_INDEX_H */
