/*  Global Declarations for Simple SUIF Library */

/*  Copyright (c) 1994 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#include <suif_copyright.h>

#ifndef GLOBALS_H
#define GLOBALS_H

extern "C" {
#include "simple.h"
}
#include "ops.h"
#include "regmap.h"

/*  global function declarations */
extern void convert_tree(tree_node *tn, void *);
extern void simplify_globals(global_symtab *gsyms, file_symtab *fsyms);
extern simple_instr *simplify_proc(proc_sym *p, reg_map *r, op_map *o,
				   annote **lp);
extern void translate_proc(simple_instr *s, proc_sym *p, op_map *o,
			   annote *line_annote);
extern void optimize_tree(tree_node *tn, void *);
extern simple_reg *new_reg(simple_type *t, reg_kind knd, int rnum);
extern type_node *new_ptr_type(type_node *t);

/*  annotations used internally */
extern char *k_simple_reg;
extern char *k_simple_machine_reg;
extern char *k_simple_sym;
extern char *k_simple_type;

#endif /* GLOBALS_H */
