/*  Simple SUIF Opcode Tables */

/*  Copyright (c) 1994 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#include <suif_copyright.h>

#define _MODULE_ "libsimple.a"

#include <suif.h>
#include "globals.h"



/* SUIF if_ops -> simple_op map */
static simple_op simple_op_map[io_last];



/*  initialize the simple->SUIF opcode mapping */
static if_ops suif_op_map[] = {
#undef SOP
#define SOP(OPCODE, NAME, FORM, SUIFOP) SUIFOP ,
#include "simple_ops.def"
};



/*  initialize the opcode->name mapping */
static char *simple_op_names[] = {
#undef SOP
#define SOP(OPCODE, NAME, FORM, SUIFOP) NAME ,
#include "simple_ops.def"
};



/*  initialize the opcode->format mapping */
static simple_format simple_op_formats[] = {
#undef SOP
#define SOP(OPCODE, NAME, FORM, SUIFOP) FORM ,
#include "simple_ops.def"
};



/*  Set up the simple_op_map[] array to map suif opcodes to the corresponding
    simple_ops.  The reverse mapping in suif_op_map[] is initialized from the
    simple_ops.def file.  */

op_map::op_map ()
{
    int io, op;

    /* default: assume that no simple_op corresponds to an if_ops member */
    for (io = 0; io < io_last; io++) {
	simple_op_map[io] = LAST_OP;
    }

    /* now go through the table and add any corresponding opcodes */
    for (io = 0; io < io_last; io++) {
	for (op = 0; op < LAST_OP; op++) {
	    if (suif_op_map[op] == io) {
		simple_op_map[io] = (simple_op)op;
		break;
	    }
	}
    }
}



/*  Convert a SUIF opcode (if_ops) to a simple_op.  This function uses the
    simple_op_map[] array to translate the opcodes.  An error occurs if
    there is no simple_op corresponding to an if_ops value.  */

simple_op
op_map::simplify_opcode (if_ops o)
{
    return simple_op_map[o];
}



/*  Lookup and return the SUIF opcode that corresponds to the specified
    simple_op opcode.  */

if_ops
op_map::translate_opcode (simple_op o)
{
    return suif_op_map[o];
}



/*  Return a printable representation for an opcode.  */

extern "C" char *
simple_op_name (simple_op o)
{
    if (o >= LAST_OP) simple_error("unknown opcode");
    return simple_op_names[o];
}



/*  Return the format used for an opcode.  */

extern "C" simple_format
simple_op_format (simple_op o)
{
    if (o >= LAST_OP) simple_error("unknown opcode");
    return simple_op_formats[o];
}



