/*  Register Map Declarations */

/*  Copyright (c) 1994 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#include <suif_copyright.h>

#ifndef REGMAP_H
#define REGMAP_H

#pragma interface

#define REG_MAP_SIZE 100

/*  The register map is a hash table that records all of the simple_reg
    structures created within each procedure.  The table is emptied at
    the beginning of each procedure.  Only pseudo and temporary registers
    are handled here; the hard registers are created before translating
    any procedures and remain unchanged throughout the program. */

class reg_map {
private:
    int size;				/* number of buckets */
    alist *bucket;			/* array of lists */
    int nxt;				/* next unused register number */

    int hash(int rnum)			{ return rnum % size; }

public:
    reg_map(int sz);
    ~reg_map();

    void empty();			/* empty out the table */
    simple_reg *get_reg(int r);		/* lookup mapping */
    void set_reg(int r, simple_reg *reg);
    int next_num()			{ return nxt++; }
};

extern void init_machine_regs();

#endif /* REGMAP_H */
