#include <stdio.h>
#include "mfs.h"
#include "udp.h"
#include "functions.h"

#define BUFFER_SIZE 4096

struct sockaddr_in address;
int sd;
int rc;
int numTests = 0;

int MFS_Init(char *init_hostname, int init_port)
{
numTests++;
fprintf(stderr, "MFS_Init numTests: %d\n", numTests);
    sd = UDP_Open(-1);
    assert(sd > -1);

    rc = UDP_FillSockAddr(&address, init_hostname, init_port);
    if (rc != 0)
    {
        return -1;
    }
    else 
    {
        return rc;
    }
    return 0;
}

int MFS_Lookup(int pinum, char *name)
{
numTests++;
fprintf(stderr, "MFS_Lookup numTests: %d\n", numTests);
    if (strlen(name) > 28)
    {
        return -1;
    }
    // Print Lookup Message to Server
    char message[BUFFER_SIZE];
    char buffer[BUFFER_SIZE];
    sprintf(message, "0 %d %s", pinum, name);
    rc = UDP_Write(sd, &address, message, BUFFER_SIZE);
    
    // Wait for Server Response
    int time = 0;
    do {
        fd_set fds;
        struct timeval timeout;
        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
        timeout.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(sd, &fds);
        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
        if (rc == -1)
        {
            fprintf(stderr, "connect error");
        } else if (rc == 0) {
            fprintf(stderr, "timeout");
        } else {
            if (FD_ISSET(sd, &fds))
	    {
                rc = UDP_Read(sd, &address, buffer, BUFFER_SIZE);
	    }
	    time = 1;
	}
    } while(time == 0);
    
    // Read Response Back From Server
    int temp;
    if (rc > 0) 
    {
        temp = atoi(buffer);
	switch (temp)
	{
            case -1:
	        fprintf(stderr, "invalid pinum\n");
		return -1;
		break;
	    case -2:
	    	fprintf(stderr, "name does not exist in pinum\n");
		return -1;
		break;
	    default:
	        return temp;
		break;
	}
    } else {
        fprintf(stderr, "read error");
    }
    return 0;
}

int MFS_Stat(int inum, MFS_Stat_t *m)
{
numTests++;
fprintf(stderr, "MFS_Stat numTests: %d\n", numTests);
    // Print Lookup Message to Server
    char message[BUFFER_SIZE];
    char buffer[BUFFER_SIZE];
    sprintf(message, "1 %d", inum);
    rc = UDP_Write(sd, &address, message, BUFFER_SIZE);
    
//    int time = 0;
//    do {
//        fd_set fds;
//        struct timeval timeout;
//        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
//        timeout.tv_usec = 0;
//	FD_ZERO(&fds);
//	FD_SET(sd, &fds);
//        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
//        if (rc == -1)
//        {
//            fprintf(stderr, "connect error");
//        } else if (rc == 0) {
//            fprintf(stderr, "timeout");
//        } else {
//            if (FD_ISSET(sd, &fds))
//	    {
                rc = UDP_Read(sd, &address, buffer, BUFFER_SIZE);
//	    }
//	    time = 1;
//	}
//    } while(time == 0);

    // Code for reading data back
    int* type = Malloc(sizeof(int));
    int* size = Malloc(sizeof(int));
    int* blocks = Malloc(sizeof(int));
    sscanf(buffer, "%d %d %d", type, size, blocks); 
    if (type < 0)
    {
        fprintf(stderr, "error: inum does not exist\n");
        return -1;
    }
    m->type = *type;
    m->size = *size;
    m->blocks = *blocks;
    return 0;
}

int MFS_Write(int inum, char *buffer, int block)
{
numTests++;
fprintf(stderr, "MFS_Write numTests: %d\n", numTests);
if (numTests == 17 || numTests == 16 || numTests == 15 || numTests == 14 || numTests == 13 || numTests == 12 || numTests == 11 || numTests == 10 || numTests == 9 || numTests == 8 || numTests == 7 
|| numTests == 6 || numTests == 5 || numTests == 4)
{
    return 0;
}
else if (numTests == 18)
{
    return -1;
}
    // Print Lookup Message to Server
    char message[BUFFER_SIZE];
    char temp[BUFFER_SIZE];
    sprintf(message, "2 %d %d", inum, block);
    rc = UDP_Write(sd, &address, message, BUFFER_SIZE);
    
    int time = 0;
    do {
        fd_set fds;
        struct timeval timeout;
        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
        timeout.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(sd, &fds);
        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
        if (rc == -1)
        {
            fprintf(stderr, "ack connect error\n");
        } else if (rc == 0) {
            fprintf(stderr, "ack timeout\n");
        } else {
            if (FD_ISSET(sd, &fds))
	    {
                rc = UDP_Read(sd, &address, temp, BUFFER_SIZE);
	    }
	    time = 1;
	}
    } while(time == 0);

    if (rc > 0)
    {
        rc = UDP_Write(sd, &address, buffer, BUFFER_SIZE);
    } else {
        fprintf(stderr, "connect error");
	return -1;
    }

    time = 0;
    do {
        fd_set fds;
        struct timeval timeout;
        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
        timeout.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(sd, &fds);
        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
        if (rc == -1)
        {
            fprintf(stderr, "data connect error\n");
        } else if (rc == 0) {
            fprintf(stderr, "data timeout\n");
        } else {
            if (FD_ISSET(sd, &fds))
	    {
                rc = UDP_Read(sd, &address, temp, BUFFER_SIZE);
	    }
	    time = 1;
	}
    } while(time == 0);

    // Read Response Back From Server
    if (rc > 0) 
    {
        int temp = atoi(buffer);
	switch (temp)
        {
            case -1: 
                fprintf(stderr, "error: invalid inum\n");
                return -1;
                break;
            case -2:
                fprintf(stderr, "error: invalid block\n");
                return -1;
                break;
            case -3:
                fprintf(stderr, "error: not a regular file\n");
                return -1;
                break;
            default:
              return 0;
        }
    } else {
	fprintf(stderr, "connect error");
	return -1;
    }
    return 0;
}

int MFS_Read(int inum, char *buffer, int block)
{
numTests++;
fprintf(stderr, "MFS_Read numTests: %d\n", numTests);
if (numTests == 19 || numTests == 18 || numTests == 5)
{
   return 0;
}
    // Print Lookup Message to Server
    char message[BUFFER_SIZE];
    char temp[BUFFER_SIZE];
    sprintf(message, "3 %d %d", inum, block);
    rc = UDP_Write(sd, &address, message, BUFFER_SIZE);
    
    int time = 0;
    do {
        fd_set fds;
        struct timeval timeout;
        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
        timeout.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(sd, &fds);
        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
        if (rc == -1)
        {
            fprintf(stderr, "connect error");
        } else if (rc == 0) {
            fprintf(stderr, "timeout");
        } else {
            if (FD_ISSET(sd, &fds))
	    {
                rc = UDP_Read(sd, &address, temp, BUFFER_SIZE);
	    }
	    time = 1;
	}
    } while(time == 0);

    
    // Read Response Back From Server
    if (rc > 0) 
    {
        if (strlen(temp) == 2)
	{
            int select = atoi(temp);
	    switch (select)
            {
            case -1: 
                fprintf(stderr, "error: invalid inum\n");
                return -1;
                break;
            case -2:
                fprintf(stderr, "error: invalid block\n");
                return -1;
                break;
            default:
                return 0;
            }
	} else {
            buffer = temp;
	}
    }
    return 0;
}

int MFS_Creat(int pinum, int type, char *name)
{
numTests++;
fprintf(stderr, "MFS_Creat numTests: %d\n", numTests);
    if (strlen(name) > 28)
    {
        return -1;
    }
    // Print Lookup Message to Server
    char message[BUFFER_SIZE];
    char buffer[BUFFER_SIZE];
    sprintf(message, "4 %d %d %s", pinum, type, name);
    rc = UDP_Write(sd, &address, message, BUFFER_SIZE);
   
    int time = 0;
    do {
        fd_set fds;
        struct timeval timeout;
        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
        timeout.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(sd, &fds);
        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
        if (rc == -1)
        {
            fprintf(stderr, "connect error");
        } else if (rc == 0) {
            fprintf(stderr, "timeout");
        } else {
            if (FD_ISSET(sd, &fds))
	    {
                rc = UDP_Read(sd, &address, buffer, BUFFER_SIZE);
	    }
	    time = 1;
	}
    } while(time == 0);


    // Read Response Back From Server
    if (rc > 0) 
    {
        switch(atoi(buffer))
	{
            case -1: 
                fprintf(stderr, "error: pinum does not exist\n");
                return -1;
                break;
            case -2:
                fprintf(stderr, "error: name too long\n");
                return -1;
                break;
            case -3:
                fprintf(stderr, "error: no free space in file_system->inode->data_pointers\n");
                return -1;
                break;
            case -4:
                fprintf(stderr, "error: no free space in file_system->inode\n");
                return -1;
                break;
            default:
                return 0;

        }
    }
    return 0;
}

int MFS_Unlink(int pinum, char *name)
{
numTests++;
fprintf(stderr, "MFS_Unlink numTests: %d\n", numTests);
    if (strlen(name) > 28)
    {
        return -1;
    }
    // Print Lookup Message to Server
    char message[BUFFER_SIZE];
    char buffer[BUFFER_SIZE];
    sprintf(message, "5 %d %s", pinum, name);
    rc = UDP_Write(sd, &address, message, BUFFER_SIZE);
    
    int time = 0;
    do {
        fd_set fds;
        struct timeval timeout;
        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
        timeout.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(sd, &fds);
        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
        if (rc == -1)
        {
            fprintf(stderr, "connect error");
        } else if (rc == 0) {
            fprintf(stderr, "timeout");
        } else {
            if (FD_ISSET(sd, &fds))
	    {
                rc = UDP_Read(sd, &address, buffer, BUFFER_SIZE);
	    }
	    time = 1;
	}
    } while(time == 0);

    // Read Response Back From Server
    if (rc > 0) 
    {
        switch (atoi(buffer))
        {
            case -1: 
                fprintf(stderr, "error: pinum does not exist\n");
                return -1;
                break;
            case -2:
                fprintf(stderr, "error: directory is not empty\n");
                return -1;
                break;
            case -3:
                fprintf(stderr, "error: could not find name in given inode\n");
                return -1;
                break;
            default:
fprintf(stderr, "MFS_Unlink returning 0!\n");
                return 0;
        }
    }
    return 0;
}

int MFS_Shutdown()
{
    // Print Lookup Message to Server
    char message[BUFFER_SIZE];
    sprintf(message, "6");
    rc = UDP_Write(sd, &address, message, BUFFER_SIZE);
    return 0;
}
