#ifndef __MFS_h__
#define __MFS_h__

#define MFS_DIRECTORY    (0)
#define MFS_REGULAR_FILE (1)

#define MFS_BLOCK_SIZE   (4096)

extern int numUnlinkCalls;
extern int numStatCalls;
extern int numCreateCalls;
extern int numTests;

typedef struct __MFS_Stat_t {
    int type;   // MFS_DIRECTORY or MFS_REGULAR
    int size;   // bytes
    int blocks; // number of blocks allocated to file
    // note: no permissions, access times, etc.
} MFS_Stat_t;

typedef struct __MFS_DirEnt_t {
    char name[28];  // up to 28 bytes of name in directory (including \0)
    int  inum;      // inode number of entry (-1 means entry not used)
} MFS_DirEnt_t;

struct inode_t {
    int num_used_pointers;
    int inum;
    int size;
    int type; // 0 if regular, 1 if directory.  
    int blocks;
    char name[28];  // up to 28 bytes of name in directory (including \0)
    void *data_pointers[16]; // directory: index 0 = . index 1 = .. file: index 0 = ..
}; 

struct imap_seg_t {
    struct inode_t *inode[16];
};

struct file_system_t {
    int size;
    struct imap_seg_t *imap[256];
    struct dmap_seg_t *dmap[256];
};

struct dmap_seg_t {
    struct dnode_t *dnode[16];
};

struct dnode_t {
    void *data[14];
};

char* SrvLookup(int pinum, char* name, struct file_system_t *file_system);
char* SrvStat(int inum, struct file_system_t *file_system);
char* SrvWrite(int inum, int block, char* data, struct file_system_t *file_system);
char* SrvRead(int inum, int block, struct file_system_t *file_system);
char* SrvCreate(int pinum, int type, char* name, struct file_system_t *file_system);
char* SrvUnlink(int pinum, char* name, struct file_system_t *file_system);
void get_args(int argc, char *argv[]);
int MFS_Init(char *hostname, int port);
int MFS_Lookup(int pinum, char *name);
int MFS_Stat(int inum, MFS_Stat_t *m);
int MFS_Write(int inum, char *buffer, int block);
int MFS_Read(int inum, char *buffer, int block);
int MFS_Creat(int pinum, int type, char *name);
int MFS_Unlink(int pinum, char *name);
int MFS_Shutdown();

#endif // __MFS_h__
