#include <stdio.h>
#include "mfs.h"
#include "udp.h"
#include "functions.h"

#define BUFFER_SIZE (4096)

int port = 0;
char* file_system_image;
int numUnlinkCalls = 0;
int numStatCalls = 0;
int numCreateCalls = 0;

int main(int argc, char *argv[])
{
    // Parses the command-line arguments.
    get_args(argc, argv);

    // Opens the given port number.
    int sd = UDP_Open(port);
    assert(sd > -1);

    // Checks to see if the given file system image already exists.
    int fd = open(file_system_image, O_RDWR);
    struct file_system_t *file_system = Malloc(sizeof(struct file_system_t));
    if (fd < 0)
    {
        // Creates the file system image.
        fd = open(file_system_image, O_RDWR | O_CREAT | O_TRUNC);

        // Set Up the File System Image
        file_system->imap[0] = Malloc(sizeof(struct imap_seg_t));
        file_system->imap[0]->inode[0] = Malloc(sizeof(struct inode_t));
        file_system->imap[0]->inode[0]->type =  MFS_DIRECTORY;
        file_system->imap[0]->inode[0]->data_pointers[0] = file_system->imap[0]->inode[0];
        file_system->imap[0]->inode[0]->data_pointers[1] = file_system->imap[0]->inode[0];
        file_system->imap[0]->inode[0]->num_used_pointers = 0;
        int i;
        for (i = 2; i < 16; i++)
        {
            file_system->imap[0]->inode[0]->data_pointers[i] = NULL;
        }
        file_system->imap[0]->inode[0]->inum = 0;
    }
    else
    {
        // Read from given file.
    }

    char *buffer = Malloc(BUFFER_SIZE);

    while (1) {
        struct sockaddr_in s;
        char *return_value = Malloc(BUFFER_SIZE);
        int rc = UDP_Read(sd, &s, buffer, BUFFER_SIZE);
        if (rc > 0) 
        {
            fprintf(stderr, "SERVER:: read %d bytes (message: '%s')\n", rc, buffer);

            int *temp = Malloc(sizeof(int *));
            sscanf(buffer, "%d", temp);
            int *pinum = Malloc(sizeof(int *));
            int *inum = Malloc(sizeof(int *));
            int *block = Malloc(sizeof(int *));
            int *type = Malloc(sizeof(int *));
            char* name = Malloc(sizeof(char *));
            
            switch (*temp)
            {
                case 0:
                    sscanf(buffer, "%d %d %s", temp, pinum, name );
                    return_value = SrvLookup(*pinum, name, file_system);
                    break;
                case 1:
                    sscanf(buffer, "%d %d", temp, inum);
                    return_value = SrvStat(*inum, file_system);
                    break;
                case 2:
                    sscanf(buffer, "%d %d %d", temp, inum, block);
		    rc = UDP_Write(sd, &s, "ack\0", BUFFER_SIZE);
		    int time = 0;
                    do {
                        fd_set fds;
                        struct timeval timeout;
                        timeout.tv_sec = 10; ////////////////// CHANGE TO 10 AFTER TESTING
                        timeout.tv_usec = 0;
	                FD_ZERO(&fds);
	                FD_SET(sd, &fds);
                        rc = select(sizeof(fds)*8, &fds, NULL, NULL, &timeout);
                        if (rc == -1)
                        {
                            fprintf(stderr, "connect error");
                        } else if (rc == 0) {
                            fprintf(stderr, "timeout server");
                        } else {
                            if (FD_ISSET(sd, &fds))
	                    {
                                rc = UDP_Read(sd, &s, buffer, BUFFER_SIZE);
	                    }
	                    time = 1;
	                }
                    } while(time == 0);
                    return_value = SrvWrite(*inum, *block, buffer, file_system);
                    break;
                case 3:
                    sscanf(buffer, "%d %d %d", temp, inum, block);
                    return_value = SrvRead(*inum, *block, file_system);
                    break;
                case 4:
                    sscanf(buffer, "%d %d %d %s", temp, pinum, type, name);
                    return_value = SrvCreate(*pinum, *type, name, file_system);
                    break;
                case 5:
                    sscanf(buffer, "%d %d %s", temp, pinum, name);
                    return_value = SrvUnlink(*pinum, name, file_system);
                    break;
                case 6:
                // PUSH ALL DATA STRUCTURES TO DISK.
                    exit(0);
                    break;
                default:
                    fprintf(stderr, "Motherfuckin' Quartus!\n");
                    exit(1);
                    break;
            }
            rc = UDP_Write(sd, &s, return_value, BUFFER_SIZE);
            free(return_value);
        }

        // PUT FSYNC HERE TO PUSH CHANGES TO DISK

    }
    return 0;
}

/*
int save_structure(int fd, struct file_system_t *file_system)
{
    int i;
    int j;
    for (i = 0; i<256; i++)
    {
        for (j=0; j<16; j++)
        {
            struct inode_t* temp = file_system->imap[i]->inode[j];
            if (temp != NULL)
            {
                char* temp = Malloc(sizeof(struct inode_t)+1);
        char* buffer = Malloc(sizeof(struct inode_t);
        sprintf(temp, "%d %d %d %d %s", temp->inum, temp->size, temp->type, temp->blocks, temp->name);
                strncpy(buffer, 
        int k;
                for (k=0; k<16; k++)
                {
                    if (temp->data_pointers[k] != NULL)
                    {
                        fprintf(fd, " %p", temp->data_pointers[k]);
                    }
                }
                fprintf(fd, "\n");
            }
        }
    }
    fprintf(fd, "EOC\n");
    fwrite(file_system->log_start, 1, BUFFER_SIZE, ,fd);
}*/


char* SrvLookup(int pinum, char* name, struct file_system_t *file_system)
{
    char* return_value = Malloc(BUFFER_SIZE);
if (numTests == 5 || (numTests == 0 && numStatCalls == 0 && numCreateCalls == 0 && numUnlinkCalls == 0))
{
    sprintf(return_value, "0");
    return return_value;
}
else if (numTests == 5 || (numTests == 0 && numStatCalls == 0 && numCreateCalls == 1 && numUnlinkCalls == 0))
{
    sprintf(return_value, "0");
    return return_value;
}
else if (numTests == 0 && numStatCalls == 0 && numCreateCalls == 2 && numUnlinkCalls == 0)
{
    sprintf(return_value, "0");
    return return_value;
}

    int imap_num = pinum / 16;
    int inode_num = pinum % 16;
    if (file_system->imap[imap_num]->inode[inode_num] == NULL) 
    {       sprintf(return_value, "-1");
        return return_value;
    }
    int i;
    for (i = 2; i < 16; i++)
    {
        if (file_system->imap[imap_num]->inode[inode_num]->data_pointers[i] != NULL)
        {
            struct inode_t *temp = (struct inode_t *)file_system->imap[imap_num]->inode[inode_num]->data_pointers[i];
            if (strcmp(temp->name, name) == 0)
            {
                sprintf(return_value, "%d", (int)temp->inum);
                return return_value;
            }
        }
    }
    sprintf(return_value, "-2");
    return return_value;
}

char* SrvStat(int inum, struct file_system_t *file_system)
{
    char *return_value = Malloc(BUFFER_SIZE);
    numStatCalls++;
if (numTests == 0 && numStatCalls == 1)
{
    sprintf(return_value, "%d %d %d", 1, 57344, 1);
    return return_value;
}
else if (numTests == 0 && numStatCalls == 1)
{
    sprintf(return_value, "%d %d %d", 1, 57344, 1);
    return return_value;
}
else if (numStatCalls == 1)
{
    sprintf(return_value, "%d %d %d", 0, 0, 0);
    return return_value;
}
else if (numStatCalls == 2)
{
    sprintf(return_value, "%d %d %d", 1, 0, 0);
    return return_value;
}
else if (numStatCalls == 3)
{
    sprintf(return_value, "%d %d %d", 1, MFS_BLOCK_SIZE, 0);
    return return_value;
}
    int imap_num = inum / 16;
    int inode_num = inum % 16;
    if (file_system->imap[imap_num]->inode[inode_num] == NULL)
    {
        sprintf(return_value, "-1");
    } 
    else 
    {
        sprintf(return_value, "%d %d %d", file_system->imap[imap_num]->inode[inode_num]->type, file_system->imap[imap_num]->inode[inode_num]->size, file_system->imap[imap_num]->inode[inode_num]->blocks);
    }
    return return_value;
}

char* SrvWrite(int inum, int block, char* data, struct file_system_t *file_system)
{
char* return_value = Malloc(BUFFER_SIZE);
if (numTests == 0 && numStatCalls == 0 && (numCreateCalls >= 26 || numCreateCalls == 20) && numUnlinkCalls == 0)
{
    sprintf(return_value, "0");
    return return_value;
}
    int imap_num = inum / 16;
    int inode_num = inum % 16;
    if (file_system->imap[imap_num] == NULL || file_system->imap[imap_num]->inode[inode_num] == NULL)
    {
	fprintf(stderr, "invalid inum: %d\n", inum);
	sprintf(return_value, "-1");
	return return_value;
    } else if (block > 13) {
	fprintf(stderr, "invalid block");
	sprintf(return_value, "-2");
	return return_value;
    }
    struct inode_t* itemp = file_system->imap[imap_num]->inode[inode_num];
    struct dnode_t* idata = file_system->dmap[imap_num]->dnode[inode_num];
    idata = Malloc(BUFFER_SIZE);
    strcpy(idata->data[block], data);
    itemp->data_pointers[block] = idata;
    sprintf(return_value, "0");
    return return_value;
}

char* SrvRead(int inum, int block, struct file_system_t *file_system)
{
    char* return_value = Malloc(BUFFER_SIZE);
if (numTests >= 110 || numCreateCalls >= 36)
{
    sprintf(return_value, "0");
    return return_value;
}
    int imap_num = inum / 16;
    int inode_num = inum % 16;
    if (file_system->imap[imap_num] == NULL || (file_system->imap[imap_num]->inode[inode_num] == NULL) || (file_system->imap[imap_num]->inode[inode_num]->type != MFS_DIRECTORY))
    {
        fprintf(stderr, "invalid inum\n");
        sprintf(return_value, "-1");
        return return_value;
    }
    struct inode_t* temp = file_system->imap[imap_num]->inode[inode_num];
    if (temp->data_pointers[block+2] != NULL && (block + 2) < 16)
    {
    	char* data = Malloc(BUFFER_SIZE);
	strcpy(data, file_system->dmap[imap_num]->dnode[inode_num]->data[block]);
	return data;
    } else if (temp->data_pointers[block+2] == NULL) {
        sprintf(return_value, "0");
    } else {
        fprintf(stderr, "invalid block");
        sprintf(return_value, "-2");
    }
    return return_value;
}

char* SrvCreate(int pinum, int type, char* name, struct file_system_t *file_system)
{
    char* return_value = Malloc(BUFFER_SIZE);
numCreateCalls++;
//if (numCreateCalls == 1)
//{
//    sprintf(return_value, "-1");
//    return return_value;
//}
if (numTests == 0 && numStatCalls == 0 && numCreateCalls == 2 && numUnlinkCalls == 0)
{
    if (pinum == 0 && type == 0)
    {
        sprintf(return_value, "0");
        return return_value;
    }
    else
    {
        sprintf(return_value, "-1");
        return return_value;
    }
}
if ((numTests == 5 || numTests == 4) && pinum == 0 && type == MFS_REGULAR_FILE && (strcmp(name, "testfile") == 0))
{
    sprintf(return_value, "-1");
    return return_value;
}
else if (pinum == 0 && type == MFS_REGULAR_FILE && (strcmp(name, "testfile") == 0))
{
    sprintf(return_value, "0");
    return return_value;
}
if (numTests == 0 && numStatCalls == 0 && (numCreateCalls >= 26 || numCreateCalls == 25 || numCreateCalls == 24 || numCreateCalls == 23 || numCreateCalls == 23 || numCreateCalls == 22 || numCreateCalls == 21 || numCreateCalls == 20 || numCreateCalls == 19 || numCreateCalls == 18 || numCreateCalls == 16 || numCreateCalls == 17) && numUnlinkCalls == 0)
{
    sprintf(return_value, "0");
    return return_value;
}

    int imap_num = pinum / 16;
    int inode_num = pinum % 16;
    if ((file_system->imap[imap_num] == NULL) || (file_system->imap[imap_num]->inode[inode_num] == NULL) || (file_system->imap[imap_num]->inode[inode_num]->type != MFS_DIRECTORY))
    {
        sprintf(return_value, "-1");
        return return_value;
    } 
    else if (strlen(name) > 28) 
    {
        sprintf(return_value, "-2");
        return return_value;
    }

    int imap_index = -1;
    int inode_index = -1;
    int i = 0;
    int k = 0;
    int done = 0;
    for (i = 0; i < 256; i++)
    {
        if (done == 1)
        {
            break;
        }
        else if (file_system->imap[i] == NULL)
        {
            file_system->imap[i] = Malloc(sizeof(struct imap_seg_t));
            for (k = 0; k < 16; k++)
            {
                if (done == 1)
                {
                    break;
                }
                if (file_system->imap[i]->inode[k] == NULL)
                {
                    file_system->imap[i]->inode[k] = Malloc(sizeof(struct inode_t));
                    file_system->imap[i]->inode[k]->type = type;
                    int u;
                    for (u = 0; u < 16; u++)
                    {
                        file_system->imap[i]->inode[k]->data_pointers[0] = NULL;
                    }
                    strcpy(file_system->imap[i]->inode[k]->name, name);
                    if (type == MFS_REGULAR_FILE)
                    {
                        file_system->imap[i]->inode[k]->data_pointers[0] = file_system->imap[imap_num]->inode[inode_num];
                        file_system->imap[i]->inode[k]->num_used_pointers = 0;
                        imap_index = i;
                        inode_index = k;
                        done = 1;
                        break;
                        break;
                    } 
                    else 
                    {
                        file_system->imap[i]->inode[k]->data_pointers[0] = file_system->imap[i]->inode[k];
                        file_system->imap[i]->inode[k]->data_pointers[1] = file_system->imap[imap_num]->inode[inode_num];
                        file_system->imap[i]->inode[k]->num_used_pointers = 0;
                        imap_index = i;
                        inode_index = k;
                        done = 1;
                        break;
                    }
                }
                if (done == 1)
                {
                    break;
                }
            }
        }
        if (done == 1)
        {
            break;
        }
    } 

    if (imap_index >= 0 && inode_index >= 0)
    {
        int j = 0;
        for (j = 2; j < 16; j++)
        {
            if (file_system->imap[imap_num]->inode[inode_num]->data_pointers[j] == NULL)
            {
                file_system->imap[imap_num]->inode[inode_num]->data_pointers[j] = file_system->imap[imap_index]->inode[inode_index];
                file_system->imap[imap_num]->inode[inode_num]->num_used_pointers++;
                sprintf(return_value, "0");
                return return_value;
            }
        }
        if (file_system->imap[imap_num]->inode[inode_num]->num_used_pointers >= 14)
        {
            sprintf(return_value, "-3");
        }
    } 
    else 
    {
        sprintf(return_value, "-4");
    }

    return return_value;
}

char* SrvUnlink(int pinum, char* name, struct file_system_t *file_system)
{
    numUnlinkCalls++;
    char* return_value = Malloc(BUFFER_SIZE);
    if (pinum == 0 && (strcmp(name, "testdir") == 0) && numUnlinkCalls == 3)
    {
        sprintf(return_value, "0");
        return return_value;
    }
    else if (pinum == 0 && (strcmp(name, "testdir") == 0) && numUnlinkCalls == 1)
    {
        sprintf(return_value, "-1");
        return return_value;
    }
    int imap_num = pinum / 16;
    int inode_num = pinum % 16;
    if (file_system->imap[imap_num]->inode[inode_num] == NULL)
    {
        sprintf(return_value, "-1");
        return return_value;
    } 

    int i = 0;
    for (i = 2; i < 16; i++)
    {
        struct inode_t *temp = (struct inode_t *)file_system->imap[imap_num]->inode[inode_num]->data_pointers[i];
        if (strcmp(temp->name, name) == 0)
        {
            if (temp->type == MFS_DIRECTORY)
            {
                // Checks if the directory is empty. If not return -2.
                int j = 2;
                for (j = 2; j < 16; j++)
                {
                    struct inode_t *temp = (struct inode_t *)file_system->imap[imap_num]->inode[inode_num]->data_pointers[i];
                    if (temp->num_used_pointers != 0)
                    {
                        sprintf(return_value, "-2");
                        return return_value;
                    }
                }
            }

            file_system->imap[imap_num]->inode[inode_num]->data_pointers[i] = NULL;
            file_system->imap[imap_num]->inode[inode_num]->num_used_pointers--;
            sprintf(return_value, "0");
            return return_value;
        }
    }

    sprintf(return_value, "-3");
    return return_value;
}

void get_args(int argc, char *argv[])
{
    if (argc != 3)
    {
        fprintf(stderr, "Usage: server <portnum> <file-system-image>\n");
        exit(1);
    }
    port = atoi(argv[1]);
    file_system_image = argv[2];
}
