/*
 * Decompiled with CFR 0.152.
 */
package javabook;

import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javabook.JavaBookDialog;

public class ListBox
extends JavaBookDialog
implements ActionListener {
    public static final int NO_SELECTION = -1;
    public static final int CANCEL = -2;
    public static final String NO_ITEM = null;
    private static final int ACTION_OK = 0;
    private static final int ACTION_CANCEL = -1;
    private List list;
    private Button okButton;
    private Button cancelButton;
    private int status;

    public ListBox(Frame frame) {
        this(frame, "Select One:", true);
    }

    public ListBox(Frame frame, String string) {
        this(frame, string, true);
    }

    public ListBox(Frame frame, String string, boolean bl) {
        super(frame, bl);
        this.setTitle(string);
        this.initialize();
    }

    public ListBox(Frame frame, boolean bl) {
        this(frame, "Select One:", bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.setVisible(false);
            this.status = 0;
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.status = -1;
        }
    }

    public void addItem(String string) {
        this.list.add(string);
    }

    protected void adjustSize() {
    }

    public void deleteItem(int n) {
        this.list.remove(n);
    }

    public void deleteItem(String string) {
        int n = 0;
        int n2 = this.list.getItemCount();
        while (n < n2 && this.list.getItem(n) != string) {
            ++n;
        }
        if (n < n2) {
            this.list.remove(n);
        }
    }

    public String getItemFromIndex(int n) {
        return this.list.getItem(n);
    }

    public int getSelectedIndex() {
        this.showIt();
        if (this.status == 0) {
            return this.list.getSelectedIndex();
        }
        if (this.status == -1) {
            return -2;
        }
        return -1;
    }

    public String getSelectedItem() {
        this.showIt();
        if (this.status == 0) {
            return this.list.getSelectedItem();
        }
        return null;
    }

    private void initialize() {
        this.setResizable(false);
        ((Component)this).setSize(170, 200);
        this.list = new List();
        this.list.setFont(this.font);
        this.add("Center", this.list);
        Panel panel = new Panel();
        this.okButton = new Button("  OK  ");
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        this.add("South", panel);
        this.addWindowListener(this);
        this.moveToCenter();
    }

    public boolean isCanceled() {
        return this.status == -1;
    }

    private void showIt() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            this.list.deselect(n);
        }
        super.setVisible(true);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        this.status = -1;
    }
}

