/*
 * Decompiled with CFR 0.152.
 */
package javabook;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javabook.JavaBookDialog;

public class MessageBox
extends JavaBookDialog
implements ActionListener,
KeyListener {
    private static final int DIALOG_HEIGHT = 130;
    private static final int DIALOG_WIDTH = 300;
    private static final char ENTER_KEY = '\n';
    private Label label;
    private Button okButton;
    private Font font;

    public MessageBox(Frame frame) {
        super(frame, true);
        this.initialize();
    }

    public MessageBox(Frame frame, boolean bl) {
        super(frame, bl);
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.setVisible(false);
        }
    }

    protected void adjustSize() {
        int n = 130;
        int n2 = 300;
        Insets insets = this.getInsets();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.font);
        int n3 = fontMetrics.stringWidth(this.label.getText());
        int n4 = n3 + 60 + insets.left + insets.right;
        if (n2 < n4) {
            n2 = n4;
        }
        ((Component)this).setSize(n2, n);
        int n5 = (n2 - insets.left - insets.right) / 2;
        this.label.setBounds(n5 - n3 / 2, n / 3, n3, 20);
        this.okButton.setBounds(n5 - 25, 100, 50, 20);
    }

    private void initialize() {
        this.font = new Font("Helvetica", 0, 12);
        this.setResizable(false);
        this.setForeground(Color.black);
        ((Component)this).setBackground(Color.white);
        this.setLayout(null);
        this.label = new Label();
        this.label.setFont(this.font);
        this.add(this.label);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        this.addWindowListener(this);
        this.okButton.addKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void show(char c) {
        this.show(" " + c + " ");
    }

    public void show(char c, int n, int n2) {
        this.show(" " + c + " ", n, n2);
    }

    public void show(double d) {
        this.show(" " + d + " ");
    }

    public void show(double d, int n, int n2) {
        this.show(" " + d + " ", n, n2);
    }

    public void show(long l) {
        this.show(" " + l + " ");
    }

    public void show(long l, int n, int n2) {
        this.show(" " + l + " ", n, n2);
    }

    public void show(String string) {
        this.label.setText(string);
        this.adjustSize();
        this.moveToCenter();
        super.setVisible(true);
    }

    public void show(String string, int n, int n2) {
        this.label.setText(string);
        this.adjustSize();
        ((Component)this).setLocation(n, n2);
        this.wasMoved = true;
        super.setVisible(true);
    }

    public void show(StringBuffer stringBuffer) {
        this.show(stringBuffer.toString());
    }

    public void show(StringBuffer stringBuffer, int n, int n2) {
        this.show(stringBuffer.toString(), n, n2);
    }
}

