/*
 * Decompiled with CFR 0.152.
 */
package javabook;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import javabook.JavaBookDialog;

public class OutputBox
extends JavaBookDialog {
    private TextArea outputArea;
    private Font font = new Font("Courier", 0, 12);

    public OutputBox(Frame frame) {
        this(frame, "OutputBox");
    }

    public OutputBox(Frame frame, int n, int n2) {
        this(frame, n, n2, "OutputBox");
    }

    public OutputBox(Frame frame, int n, int n2, String string) {
        super(frame, false);
        this.setTitle(string);
        this.initialize(n, n2);
    }

    public OutputBox(Frame frame, String string) {
        this(frame, 550, 380, string);
    }

    protected void adjustSize() {
    }

    protected void adjustSize(int n, int n2) {
        ((Component)this).setSize(n, n2);
    }

    public void appendToFile(String string) {
        this.writeToFile(string, true);
    }

    public void clear() {
        this.outputArea.setText("");
    }

    private void initialize(int n, int n2) {
        this.pack();
        this.setResizable(true);
        this.outputArea = new TextArea();
        this.setFont(this.font);
        this.add((Component)this.outputArea, "Center");
        this.adjustSize(n, n2);
        this.moveToCenter();
        this.addWindowListener(this);
    }

    private void newLine() {
        this.outputArea.append("\r\n");
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(String string) {
        this.outputArea.append(string);
    }

    public void print(StringBuffer stringBuffer) {
        this.print(stringBuffer.toString());
    }

    public void print(boolean bl) {
        this.print(String.valueOf(bl));
    }

    public void printLine(char c) {
        this.printLine(String.valueOf(c));
    }

    public void printLine(double d) {
        this.printLine(String.valueOf(d));
    }

    public void printLine(long l) {
        this.printLine(String.valueOf(l));
    }

    public void printLine(String string) {
        this.print(string);
        this.newLine();
    }

    public void printLine(StringBuffer stringBuffer) {
        this.printLine(stringBuffer.toString());
    }

    public void printLine(boolean bl) {
        this.printLine(String.valueOf(bl));
    }

    public void saveToFile(String string) {
        this.writeToFile(string, false);
    }

    public void setFont(Font font) {
        if (this.outputArea != null) {
            this.outputArea.setFont(font);
        }
        this.font = font;
    }

    public void skipLine(int n) {
        if (n > 0 || n < 21) {
            int n2 = 0;
            while (n2 < n) {
                this.newLine();
                ++n2;
            }
        }
    }

    public void waitUntilClose() {
        this.setVisible(false);
        this.setModal(true);
        this.setVisible(true);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        this.setModal(false);
    }

    private void writeToFile(String string, boolean bl) {
        try {
            FileWriter fileWriter = new FileWriter(string, bl);
            fileWriter.write(this.outputArea.getText());
            fileWriter.close();
        }
        catch (IOException iOException) {}
    }
}

