/******************************* MAIN HEADER **********************************
    Title:       Cylinder Volume, version 2
    File:        CylinderVolume2.java
    
    Author:      James D. Skrentny, skrentny@cs.wisc.edu
                 copyright 2000 all rights reserved
    Course:      CS 302: Lectures 1 & 2
    
    Compiler:    CodeWarrior IDE 4.0 (JDK 1.2)
    Platform:    Windows NT 4.0
 **************************** 80 columns wide *********************************/

import javabook.*;  // package containing simple GUI for input and output

/**
 * This program calculates the volume of any cylinder.
 *
 * Bugs: none known
 **/

/*
 * The approach shown below is flexible since the program user enters the
 * size of the cylinder's dimensions.  However there are still problems with
 * this approach.  What are they? We'll see later in Cylinder Volume version 3.
 */

class CylinderVolume2 {

    public static void main(String[] args) {

        // declare variables and get initial values
        MainWindow mainWindow = new MainWindow("Cylinder Volume Calculator");
        mainWindow.show();

        double height, radius, volume;

        InputBox  inputBox  = new InputBox (mainWindow);
        height = inputBox.getDouble("Enter cylinder\'s height (centimeters)");
        radius = inputBox.getDouble("Enter cylinder\'s radius (centimeters)");

        // calculate the volume
        volume = Math.PI * Math.pow(radius, 2) * height;

        // display the result
        OutputBox outputBox = new OutputBox (mainWindow);
        outputBox.print    ("A cylinder of height " + height + " centimeters");
        outputBox.printLine(" and radius " + radius + " centimeters");
        outputBox.printLine("has a volume of " + volume + " centimeters cubed.");
        outputBox.show();
    }

}
