/*
 * Decompiled with CFR 0.152.
 */
package javabook;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javabook.JavaBookDialog;

public class InputBox
extends JavaBookDialog
implements ActionListener,
KeyListener {
    private static String DEFAULT_TITLE = "InputBox";
    private static String DEFAULT_ERR_MSG = "Invalid entry. Try again...";
    private static int FIELD_WIDTH = 15;
    private TextField inputLine;
    private Label prompt;
    private Label errorMessage;
    private Button okButton;
    private Font font;
    private String errorMsgText;
    private boolean showErrorMsg;

    public InputBox(Frame frame) {
        this(frame, DEFAULT_TITLE);
    }

    public InputBox(Frame frame, String string) {
        this(frame, string, DEFAULT_ERR_MSG);
    }

    public InputBox(Frame frame, String string, String string2) {
        super(frame, true);
        this.initialize(string, string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.dispose();
        }
    }

    protected void adjustSize() {
        int n;
        int n2 = 150;
        int n3 = 200;
        this.addNotify();
        Insets insets = this.getInsets();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.font);
        int n4 = fontMetrics.stringWidth(this.prompt.getText());
        int n5 = this.inputLine.getPreferredSize().width;
        int n6 = fontMetrics.stringWidth(this.errorMsgText);
        int n7 = Math.max(n4, n5);
        if (this.showErrorMsg) {
            n7 = Math.max(n6, n7);
        }
        if (n3 < (n = n7 + 60 + insets.left + insets.right)) {
            n3 = n;
        }
        ((Component)this).setSize(n3, n2);
        int n8 = (n3 - insets.left - insets.right) / 2;
        if (n4 < n5) {
            this.prompt.setBounds(n8 - n5 / 2, insets.top + 35, n4, 20);
        } else {
            this.prompt.setBounds(n8 - n4 / 2, insets.top + 35, n4, 20);
        }
        this.inputLine.setBounds(n8 - n5 / 2, insets.top + 60, n5, 20);
        this.okButton.setBounds(n8 - 25, n2 - insets.bottom - 25, 50, 20);
        this.errorMessage.setBounds(n8 - n6 / 2, insets.top + 10, n6, 20);
    }

    private void clearInputLine() {
        this.inputLine.setText("");
    }

    public double getDouble() {
        return this.getDouble("Enter a double:");
    }

    public double getDouble(String string) {
        this.setPrompt(string);
        this.showIt(false);
        boolean bl = false;
        double d = 0.0;
        do {
            try {
                Double d2 = Double.valueOf(this.getInputLine());
                d = d2;
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showIt(true);
            }
        } while (!bl);
        return d;
    }

    public float getFloat() {
        return this.getFloat("Enter a float:");
    }

    public float getFloat(String string) {
        this.setPrompt(string);
        this.showIt(false);
        boolean bl = false;
        float f = 0.0f;
        do {
            try {
                Float f2 = Float.valueOf(this.getInputLine());
                f = f2.floatValue();
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showIt(true);
            }
        } while (!bl);
        return f;
    }

    private String getInputLine() {
        return this.inputLine.getText();
    }

    public int getInteger() {
        return this.getInteger("Enter an integer:");
    }

    public int getInteger(String string) {
        this.setPrompt(string);
        this.showIt(false);
        boolean bl = false;
        int n = 0;
        do {
            try {
                n = Integer.parseInt(this.getInputLine());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showIt(true);
            }
        } while (!bl);
        return n;
    }

    public String getString() {
        return this.getString("Enter a string:");
    }

    public String getString(String string) {
        this.setPrompt(string);
        this.showIt(false);
        boolean bl = false;
        return this.getInputLine();
    }

    private void initialize(String string, String string2) {
        this.setResizable(false);
        this.setForeground(Color.black);
        ((Component)this).setBackground(Color.white);
        this.setLayout(null);
        this.setTitle(string);
        this.font = new Font("Helvetica", 0, 12);
        this.errorMsgText = string2;
        this.inputLine = new TextField(FIELD_WIDTH);
        this.inputLine.setFont(this.font);
        this.add(this.inputLine);
        this.prompt = new Label("Enter Data:");
        this.prompt.setFont(this.font);
        this.add(this.prompt);
        this.showErrorMsg = false;
        this.errorMessage = new Label(this.errorMsgText);
        this.errorMessage.setFont(this.font);
        this.add(this.errorMessage);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        this.addWindowListener(this);
        this.inputLine.addKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.dispose();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void setPrompt(String string) {
        this.prompt.setText(string);
    }

    private void showIt(boolean bl) {
        this.errorMessage.setVisible(false);
        this.inputLine.setVisible(false);
        this.prompt.setVisible(false);
        this.okButton.setVisible(false);
        this.showErrorMsg = bl;
        if (this.showErrorMsg) {
            this.errorMessage.setVisible(true);
        } else {
            this.clearInputLine();
        }
        this.inputLine.setVisible(true);
        this.prompt.setVisible(true);
        this.okButton.setVisible(true);
        this.inputLine.requestFocus();
        this.setVisible(true);
    }
}

