/*
 * Decompiled with CFR 0.152.
 */
package javabook;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javabook.JavaBookDialog;

public class MultiInputBox
extends JavaBookDialog
implements ActionListener {
    private static final int ACTION_PENDING = 0;
    private static final int ACTION_OK = 1;
    private static final int ACTION_CANCEL = 2;
    private int status;
    private TextField[] inputLine;
    private Label[] prompt;
    private Button okButton;
    private Button cancelButton;
    private Font font;
    private int numOfRows;
    private int currentLine;

    public MultiInputBox(Frame frame, int n) {
        super(frame, true);
        this.numOfRows = n;
        this.initialize();
    }

    public MultiInputBox(Frame frame, String[] stringArray) {
        this(frame, stringArray.length);
        this.setLabels(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.setVisible(false);
            this.status = 1;
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.status = 2;
            this.clearInputLines();
        }
    }

    protected void adjustSize() {
        int n = 230;
        int n2 = 300;
        int n3 = 60;
        int n4 = 25;
        int n5 = 10;
        int n6 = 10;
        int n7 = 10;
        int n8 = 40;
        int n9 = 20;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.font);
        int n10 = 0;
        int n11 = 0;
        while (n11 < this.numOfRows) {
            int n12 = fontMetrics.stringWidth(this.prompt[n11].getText());
            if (n12 > n10) {
                n10 = n12;
            }
            ++n11;
        }
        int n13 = 22;
        int n14 = 100;
        int n15 = n6 + n10 + 25 + n5;
        int n16 = 0;
        while (n16 < this.numOfRows) {
            this.prompt[n16].setBounds(n6, n8 + n13 * n16, n10 + 25, n13);
            this.inputLine[n16].setBounds(n15, n8 + n13 * n16, n14, n13);
            ++n16;
        }
        n = n8 + n9 + (this.numOfRows + 1) * n13 + n4 + 10;
        n2 = n6 + n5 + n7 + n10 + 30 + n14;
        ((Component)this).setSize(n2, n);
        int n17 = (n6 + n7 + n5 + n10 + 30 + n14) / 2;
        this.okButton.setBounds(n17 - (n3 + 10), n8 + (this.numOfRows + 1) * n13, n3, n4);
        this.cancelButton.setBounds(n17 + 10, n8 + (this.numOfRows + 1) * n13, n3, n4);
    }

    private void clearInputLines() {
        int n = 0;
        while (n < this.numOfRows) {
            this.inputLine[n].setText("");
            ++n;
        }
        this.currentLine = 0;
    }

    private String[] getInputLines() {
        String[] stringArray = new String[this.inputLine.length];
        if (this.status == 2) {
            stringArray = null;
        } else {
            int n = 0;
            while (n < this.inputLine.length) {
                stringArray[n] = this.inputLine[n].getText();
                ++n;
            }
        }
        return stringArray;
    }

    public String[] getInputs() {
        this.showIt();
        boolean bl = false;
        String[] stringArray = this.getInputLines();
        this.clearInputLines();
        return stringArray;
    }

    private int getStatus() {
        return this.status;
    }

    private void initialize() {
        this.status = 0;
        this.font = new Font("Helvetica", 0, 12);
        this.currentLine = 0;
        this.setResizable(false);
        this.setForeground(Color.black);
        this.setLayout(null);
        this.setTitle("MultiInputBox");
        this.prompt = new Label[this.numOfRows];
        this.inputLine = new TextField[this.numOfRows];
        int n = 0;
        while (n < this.numOfRows) {
            this.prompt[n] = new Label();
            this.prompt[n].setFont(this.font);
            this.inputLine[n] = new TextField();
            this.inputLine[n].setFont(this.font);
            this.add(this.prompt[n]);
            this.add(this.inputLine[n]);
            ++n;
        }
        this.inputLine[0].requestFocus();
        this.okButton = new Button("  OK  ");
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.add(this.okButton);
        this.add(this.cancelButton);
        this.addWindowListener(this);
    }

    public boolean isCanceled() {
        return this.status == 2;
    }

    public void setLabels(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.prompt[n].setText(stringArray[n]);
            ++n;
        }
    }

    public void setValue(int n, String string) {
        this.inputLine[n].setText(string);
    }

    private void showIt() {
        this.adjustSize();
        this.moveToCenter();
        super.setVisible(true);
        this.inputLine[this.currentLine].requestFocus();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        this.status = 2;
    }
}

