/*
 * Decompiled with CFR 0.152.
 */
package javabook;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javabook.JavaBookDialog;

public class ResponseBox
extends JavaBookDialog
implements ActionListener {
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int CANCEL = -1;
    private static final int ACTION_PENDING = 0;
    private int status;
    private int numberOfButtons;
    private Label prompt;
    private Button[] button;
    private Font font;

    public ResponseBox(Frame frame) {
        this(frame, 2);
    }

    public ResponseBox(Frame frame, int n) {
        super(frame, true);
        this.numberOfButtons = n < 1 || n > 3 ? 1 : n;
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button[0]) {
            this.setVisible(false);
            this.status = 1;
        } else if (actionEvent.getSource() == this.button[1]) {
            this.setVisible(false);
            this.status = 2;
        } else if (actionEvent.getSource() == this.button[2]) {
            this.setVisible(false);
            this.status = 3;
        }
    }

    protected void adjustSize() {
        int n;
        int n2 = 110;
        int n3 = 200;
        Insets insets = this.getInsets();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.font);
        int n4 = fontMetrics.stringWidth(this.prompt.getText());
        int n5 = Math.max(n4, n = this.button[0].getPreferredSize().width + 5 + this.button[1].getPreferredSize().width + 5 + this.button[2].getPreferredSize().width) + 60 + insets.left + insets.right;
        if (n3 < n5) {
            n3 = n5;
        }
        ((Component)this).setSize(n3, n2);
    }

    private int getStatus() {
        return this.status;
    }

    private void initialize() {
        this.button = new Button[3];
        this.font = new Font("Helvetica", 0, 12);
        this.status = 0;
        this.setForeground(Color.black);
        Panel panel = new Panel();
        this.add("North", panel);
        Panel panel2 = new Panel();
        this.prompt = new Label();
        this.prompt.setFont(this.font);
        this.prompt.setText("   ");
        panel2.add(this.prompt);
        this.add("Center", panel2);
        Panel panel3 = new Panel();
        this.button[0] = new Button(" Yes  ");
        this.button[0].addActionListener(this);
        this.button[1] = new Button("  No  ");
        this.button[1].addActionListener(this);
        this.button[2] = new Button("Cancel");
        this.button[2].addActionListener(this);
        switch (this.numberOfButtons) {
            case 1: {
                this.button[0].setLabel("  OK  ");
                this.button[1].setVisible(false);
            }
            case 2: {
                this.button[2].setVisible(false);
            }
        }
        panel3.add(this.button[0]);
        panel3.add(this.button[1]);
        panel3.add(this.button[2]);
        this.add("South", panel3);
        this.addWindowListener(this);
    }

    public int prompt(String string) {
        this.setPrompt(string);
        this.showIt();
        return this.getStatus();
    }

    public void setLabel(int n, String string) {
        if (n <= this.numberOfButtons && n > 0) {
            this.button[n - 1].setLabel(string);
        }
    }

    private void setPrompt(String string) {
        this.prompt.setText(string);
    }

    private void showIt() {
        this.adjustSize();
        this.moveToCenter();
        super.setVisible(true);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.status = -1;
    }
}

