/******************************* MAIN HEADER **********************************
    Title:       Decision Maker
    Files:       DecisionMaker.java, Die.java
    
    Author:      James D. Skrentny, skrentny@cs.wisc.edu
                 copyright 2000 all rights reserved
    Course:      CS 302: Lectures 1 & 2
    
    Compiler:    CodeWarrior IDE 4.0 (JDK 1.2)
    Platform:    Windows NT 4.0
 **************************** 80 columns wide *********************************/

import javabook.*;  // package containing simple GUI for input and output

/**
 * This program implements an executive decision maker using a Die object.
 *
 * Bugs: none known
 **/

public class DecisionMaker {

    /**         
    * Decision Maker main program.
    **/
    public static void main (String[] args) {
    
        // get number of choices from user
        MainWindow mainWindow = new MainWindow("Decision Maker");
        mainWindow.show();
        InputBox inputBox = new InputBox(mainWindow);
        int choices = inputBox.getInteger("Enter the number of choices:");
        
        // create a Die object and roll it
        Die die = new Die(choices);
        die.roll();
        
        // display the choice this program randomly chose
        OutputBox outputBox = new OutputBox(mainWindow);
        outputBox.printLine("Choose number " + die.getTop() + ".");
        outputBox.show();
    }
    
}
