/******************************* FILE HEADER **********************************
    File:        Die.java
    
    Author:      James D. Skrentny
                 copyright 2000, all rights reserved
    Course:      CS302: Lectures 1 & 2
    
    Compiler:    CodeWarrior IDE 4.0 (JDK 1.2)
    Platform:    Windows NT 4.0
 **************************** 80 columns wide *********************************/

/**
 * The Die class represents a die for games of chance using dice.
 *
 * Bugs: none known
 **/

public class Die {

    private int sides;  // number of sides, > 0
    private int top;    // side facing up,  1 to sides inclusive
    
    /**         
    * Constructs a 6 sided die with 1 facing up.
    **/
    public Die () {
        sides = 6;
        top   = 1;
    }
    
    /**         
    * Constructs a die of a specified number of sides with 1 facing up.
    *
    * @param givenSides die's number of sides, assumed to be > 0
    **/
    public Die (int specifiedSides) {
        sides = Math.abs(specifiedSides);
        top   = 1;
    }
    
    /**         
    * Constructs a die of a given number of sides and side facing up.
    *
    * @param specifiedSides die's number of sides, assumed to be > 0
    * @param specifiedTop die's side facing up, assumed to be > 0
    *        restricts top <= sides
    **/
    public Die (int specifiedSides, int specifiedTop) {
        sides = Math.abs(specifiedSides);
        top   = ((Math.abs(specifiedTop) - 1) % sides) + 1;
    }
    
    /**         
    * Sets die's side facing up to specified value.
    *
    * @param specifiedTop die's side facing up, assumed to be > 0
    *        restricts top <= sides
    **/
    public void setTop (int specifiedTop) {
        top = ((Math.abs(specifiedTop) - 1) % sides) + 1;
    }
    
    /**         
    * Gets die's side facing up.
    *
    * @return top side (i.e. side facing up)
    **/
    public int getTop () {
        return top;
    }
    
    /**         
    * Randomly sets the die's side facing up to be: 1 <= top <= sides.
    **/
    public void roll () {
        top = (int) Math.round(sides * Math.random());
    }
    
}
