/******************************* MAIN HEADER **********************************
    Title:       Magic 8 Ball
    Files:       Magic8Ball.java, Die.java
    
    Author:      James D. Skrentny, skrentny@cs.wisc.edu
                 copyright 2000 all rights reserved
    Course:      CS 302: Lectures 1 & 2
    
    Compiler:    CodeWarrior IDE 4.0 (JDK 1.2)
    Platform:    Windows NT 4.0
 **************************** 80 columns wide *********************************/

/**
 * This program implements a magic 8 ball using a Die object.
 *
 * Bugs: none known
 **/

public class Magic8Ball {

    /**         
    * Magic 8 Ball main program.
    **/
    public static void main (String[] args) throws InterruptedException {
        
        System.out.println("Ask your question now.");
        
        Thread.sleep(4000);     // causes program to wait for 4 seconds
        
        // create 20 sided die and roll it
        Die icosahedron = new Die(20);
        icosahedron.roll();
        
        // display message corresponding to die's top value
        switch (icosahedron.getTop()) {
            case  1: System.out.println("Outlook Good");                break;
            case  2: System.out.println("Outlook Not So Good");         break;
            case  3: System.out.println("My Reply Is No");              break;
            case  4: System.out.println("Don't Count On It");           break;
            case  5: System.out.println("You May Rely On It");          break;
            case  6: System.out.println("Ask Again Later");             break;
            case  7: System.out.println("Most Likely");                 break;
            case  8: System.out.println("Cannot Predict Now");          break;
            case  9: System.out.println("Yes");                         break;
            case 10: System.out.println("Yes Definately");              break;
            case 11: System.out.println("Better Not Tell You Now");     break;
            case 12: System.out.println("It Is Certain");               break;
            case 13: System.out.println("Very Doubtful");               break;
            case 14: System.out.println("It Is Decidedly So");          break;
            case 15: System.out.println("Concentrate and Ask Again");   break;
            case 16: System.out.println("Signs Point to Yes");          break;
            case 17: System.out.println("My Sources Say No");           break;
            case 18: System.out.println("Without a Doubt");             break;
            case 19: System.out.println("Reply Hazy, Try Again");       break;
            case 20: System.out.println("As I See It, Yes");            break;
            default: System.out.println("Psychic temporarily out of service.");
        }
    }
    
}
