/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ForestFireGUI {
    private JFrame window;
    private JPanel[][] board;

    public ForestFireGUI(String filename) throws FileNotFoundException, InvalidForestException {
        Scanner fileScanner = new Scanner(new File(filename));
        if (!fileScanner.hasNextLine()) {
            fileScanner.close();
            throw new InvalidForestException(filename);
        }
        String firstLine = fileScanner.nextLine();
        String[] values = firstLine.split(",");
        int numRows = Integer.parseInt(values[0]);
        int numColumns = Integer.parseInt(values[1]);
        if (numRows <= 0 || numColumns <= 0) {
            fileScanner.close();
            throw new InvalidForestException(filename);
        }
        char[][] map = new char[numRows][numColumns];
        int i = 0;
        while (i < numRows) {
            if (!fileScanner.hasNextLine()) {
                fileScanner.close();
                throw new InvalidForestException(filename);
            }
            String line = fileScanner.nextLine();
            values = line.split(",");
            int j = 0;
            while (j < numColumns) {
                map[i][j] = values[j].charAt(0);
                ++j;
            }
            ++i;
        }
        fileScanner.close();
        this.board = new JPanel[map.length][map[0].length];
        this.window = new JFrame("Forest Fire Simulation");
        this.window.setDefaultCloseOperation(3);
        this.window.setLayout(new GridLayout(map.length, map[0].length));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth() * 0.25;
        double height = screenSize.getHeight() * 0.25;
        if (width > height) {
            width = height;
        } else {
            height = width;
        }
        this.window.setSize((int)width, (int)height);
        i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[0].length) {
                this.board[i][j] = new JPanel();
                this.window.add(this.board[i][j]);
                ++j;
            }
            ++i;
        }
        this.window.setLocationRelativeTo(null);
        i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                JPanel slot = this.board[i][j];
                switch (map[i][j]) {
                    case 'E': {
                        slot.setBackground(Color.YELLOW);
                        break;
                    }
                    case 'T': {
                        slot.setBackground(Color.GREEN);
                        break;
                    }
                    case 'B': {
                        slot.setBackground(Color.RED);
                        break;
                    }
                    default: {
                        throw new InvalidForestException(filename);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void display() {
        this.window.setVisible(true);
    }

    public void close() {
        this.window.dispose();
    }
}

