"""
script to plot boxplot of a values for all directions along with give ups
"""
from __future__ import division, print_function, absolute_import
import os
import numpy as np
from plot_utility import draw_box_plot_with_twin_axis
from data_dir import data_dir


def main():
    """the main method"""
    input_dir = os.path.join(data_dir, '3_subject_data')
    specific_strings = ['S_Red_Box', 'S_Red_Dot', 'M_Red_Dot',
                        'M_RGB_Dot', 'M_Red_Eye', 'M_RGB_Box',
                        'L_RGB_Box', 'X_RGB_Box']
    adv_strings = ['fgsm', 'pgd']
    adv_strings2 = ['FGSM', 'PGD']
    base_image_names = ['panda', 'macaw', 'cat']
    title = None

    # read data for each base image and use the a
    for base in base_image_names:
        dists_list = []
        giveup_list = []
        for key in specific_strings + adv_strings:

            input_fname = os.path.join(input_dir, '{}_{}_data.txt'.format(base,
                                                                          key))
            dists = np.genfromtxt(input_fname, dtype='str', delimiter=' ',
                                  skip_header=1, usecols=(1))
            # count number of give ups
            giveup_list.append(np.sum(dists == 'GiveUp'))
            # replace give up and append to dists list
            dists[dists == 'GiveUp'] = float('inf')
            dists = dists.astype('float')
            dists_list.append(dists)

        # draw the plot
        fname = 'a_boxplot_with_giveup_count_{}.png'.format(base)
        plt = draw_box_plot_with_twin_axis(specific_strings + adv_strings2,
                                           dists_list, giveup_list,
                                           xlabel=None, ylabel1='a',
                                           ylabel2='# GiveUp',
                                           xrotation='70', title=title,
                                           ylim1=[0, 140],
                                           ylim2=[0, 35],
                                           yticks2=np.linspace(0, 35, 8))
        plt.savefig(fname, bbox_inches='tight')
        plt.close()


if __name__ == '__main__':
    main()