"""
script to plot boxplot of EMD for all directions
"""
from __future__ import division, print_function, absolute_import
import os
import numpy as np
from plot_utility import draw_box_plot
from data_dir import data_dir


def main():
    """the main method"""
    input_dir = os.path.join(data_dir, '6_EMD')
    specific_strings = ['S_Red_Box', 'S_Red_Dot', 'M_Red_Dot',
                        'M_RGB_Dot', 'M_Red_Eye', 'M_RGB_Box',
                        'L_RGB_Box', 'X_RGB_Box']
    adv_strings = ['fgsm', 'pgd']
    adv_strings2 = ['FGSM', 'PGD']
    base_image_names = ['panda', 'macaw', 'cat']

    # read data for each base image and use the metric
    for base in base_image_names:
        dists_list = []
        for key in specific_strings + adv_strings:
            input_fname = os.path.join(input_dir, '{}_{}_data.txt'.format(base,
                                                                          key))
            dists = np.genfromtxt(input_fname, dtype='str', delimiter=' ',
                                  skip_header=1, usecols=(1))
            # replace give up and append to dists list
            dists[dists == 'GiveUp'] = float('inf')
            dists = dists.astype('float')
            dists_list.append(dists)

        # draw the plot
        title = None
        fname = 'emd_boxplot_{}.png'.format(base)
        plt = draw_box_plot(specific_strings + adv_strings2, dists_list,
                            xlabel=None,
                            ylabel='EMD',
                            xrotation='70', title=title,
                            ylim=22)
        plt.savefig(fname, bbox_inches='tight')
        plt.close()


if __name__ == '__main__':
    main()
