"""
script to plot boxplot of 1-, 2-, 3- and inf-norm for all directions
"""
from __future__ import division, print_function, absolute_import
import os
import numpy as np
from plot_utility import draw_box_plot
from data_dir import data_dir


def main():
    """the main method"""
    input_dir = os.path.join(data_dir, '5_1,2,3,inf_norm')
    specific_strings = ['S_Red_Box', 'S_Red_Dot', 'M_Red_Dot',
                        'M_RGB_Dot', 'M_Red_Eye', 'M_RGB_Box',
                        'L_RGB_Box', 'X_RGB_Box']
    adv_strings = ['fgsm', 'pgd']
    adv_strings2 = ['FGSM', 'PGD']
    base_image_names = ['panda', 'macaw', 'cat']
    dist_index_dict = {'1': 1, '2': 2, '3': 3, 'inf': 4}
    ylims_dict = {'1': 0.6 * 10**7, '2': 10**4, '3': 1500, 'inf': 120}

    # read data for each base image and use the metric
    for base in base_image_names:
        for p in dist_index_dict:
            dists_list = []
            for key in specific_strings + adv_strings:
                input_fname = os.path.join(input_dir,
                                           '{}_{}_data.txt'.format(base, key))
                dists = np.genfromtxt(input_fname, dtype='str', delimiter=' ',
                                      skip_header=1,
                                      usecols=(dist_index_dict[p]))
                # replace give up and append to dists list
                dists[dists == 'GiveUp'] = 'inf'
                dists = dists.astype('float')
                dists_list.append(dists)

            title = None
            temp = p
            if p == 'inf':
                temp = '\infty'

            fname = 'pixel_{}_norm_boxplot_{}.png'.format(p, base)
            plt = draw_box_plot(specific_strings + adv_strings2,
                                dists_list,
                                xlabel=None,
                                ylabel='pixel ${}$-norm'.format(temp),
                                xrotation='70', title=title,
                                ylim=ylims_dict[p])
            plt.ticklabel_format(axis='y', style='sci', scilimits=(-3, 4))
            plt.savefig(fname, bbox_inches='tight')
            plt.close()


if __name__ == '__main__':
    main()