function generate_perturbed_photo(x_path, v_path, a, o_path)
% generates a perturbed photo
% x_path: path to natural photo to perturb
% v_path: path to perturbation file
% a: the amoung of perturbation
% o: path to output file to save perturbed photo
    disp(x_path)
    disp(v_path)
    disp(a)
    disp(o_path)

    % load data
    x = fscanf(fopen(x_path, 'r'), '%d');
    x = reshape(x, [299, 299, 3]);

    v = fscanf(fopen(v_path, 'r'), '%f');
    v = reshape(v, [299, 299, 3]);

    % generate perturbed image
    xp = x + v * a;
    xp = uint8(xp);
    xp = reshape(xp, [299*299*3, 1]);

    % project
    xp(xp > 255) = 255;
    xp(xp < 0) = 0;
    xp = round(xp);

    % save
    fprintf(fopen(o_path, 'w'), '%d\n', xp);
end