"""
script to perform Hypothesis test 6
"""
from __future__ import division, print_function, absolute_import
from scipy import stats
import numpy as np
from data_dir import data_dir
import os


def main():
    input_file1 = os.path.join(data_dir, '7_SSIM/panda_X_RGB_Box_data.txt')
    input_file2 = os.path.join(data_dir,
                               '7_SSIM/panda_fgsm_data.txt')

    col_index = 1

    data1 = np.genfromtxt(input_file1, dtype='str', delimiter=' ',
                          skip_header=1, usecols=(col_index))
    data2 = np.genfromtxt(input_file2, dtype='str', delimiter=' ',
                          skip_header=1, usecols=(col_index))

    data1[data1 == 'GiveUp'] = 'inf'
    data2[data2 == 'GiveUp'] = 'inf'

    data1 = data1.astype('float')
    data2 = data2.astype('float')

    _, two_tailed_p = stats.ks_2samp(data1, data2)
    print('Two tailed p-value for panda X-RGB-Box and panda FGSM ' +
          '(Hypothesis Test 6): {:.1E}'.format(two_tailed_p))


if __name__ == '__main__':
    main()
