"""
script to perform Hypothesis test 9
"""
from __future__ import division, print_function, absolute_import
from scipy import stats
import numpy as np
from data_dir import data_dir
import os


def main():
    input_file1 = os.path.join(data_dir,
                               '3_subject_data/' +
                               'panda_L_RGB_Box_data.txt')
    input_file2 = os.path.join(data_dir,
                               '3_subject_data/' +
                               'panda_X_RGB_Box_data.txt')

    col_index = 1

    data1 = np.genfromtxt(input_file1, dtype='str', delimiter=' ',
                          skip_header=1, usecols=(col_index))
    data2 = np.genfromtxt(input_file2, dtype='str', delimiter=' ',
                          skip_header=1, usecols=(col_index))

    data1[data1 == 'GiveUp'] = 'inf'
    data2[data2 == 'GiveUp'] = 'inf'

    data1 = data1.astype('float')
    data2 = data2.astype('float')

    _, two_tailed_p = stats.ttest_ind(data1, data2, equal_var=False)
    print('One tailed p-value for panda L-RGB-Box and macaw X-RGB-Box ' +
          '(Hypothesis Test 9): {:.1E}'.format(two_tailed_p / 2))


if __name__ == '__main__':
    main()
