"""
script to plot the best std
"""
from __future__ import division, print_function, absolute_import
import numpy as np
import matplotlib.pyplot as plt
import os
from data_dir import data_dir


def main():
    # load the data
    input_fname = os.path.join(data_dir, '10_STD/var_pixel_p.txt')
    data = np.genfromtxt(input_fname, dtype=str, delimiter=' ', skip_header=1)

    # group by center image
    base_images = ['pixel $p$-norm panda', 'pixel $p$-norm macaw', 'pixel $p$-norm cat',
                   'EMD panda', 'EMD macaw', 'EMD cat',
                   '1 - SSIM panda', '1 - SSIM macaw', '1 - SSIM cat',
                   'DNN $p$-norm panda', 'DNN $p$-norm macaw', 'DNN $p$-norm cat']
    num_rows = len(data)
    num_base = 3
    num_row_per_base = num_rows // num_base
    colors = ['b', 'g', 'tab:orange']

    # convert the data and draw the plots for each image
    x = np.array(range(num_row_per_base)) + 1
    for i in range(num_base):
        start, end = num_row_per_base * i, num_row_per_base * (i + 1)
        entries = data[start:end]
        y = entries[:, 2].astype('float')
        y = np.sqrt(y)
        plt.plot(x, y, 'o-', color=colors[i])

    # plot emd
    emd_stds = [0.027, 0.03, 0.032]
    for i, std in enumerate(emd_stds):
        plt.plot([0, 13], [std, std], '--', color=colors[i])

    ssim_stds = [0.053, 0.078, 0.055]
    for i, std in enumerate(ssim_stds):
        plt.plot([0, 13], [std, std], ':', color=colors[i])


    # read dnn results
    input_fname = os.path.join(data_dir, '10_STD/std_dnn_representation.txt')
    data = np.genfromtxt(input_fname, dtype=str, delimiter=' ')
    num_rows = len(data)
    num_row_per_base = num_rows // num_base
    x2 = np.array(range(num_row_per_base)) + 1
    x2[-1] = 12

    for i in range(num_base):
        start, end = num_row_per_base * i, num_row_per_base * (i + 1)
        entries2 = data[start:end]
        y = entries2[:, 2].astype('float')
        plt.plot(x2, y, ':.', color=colors[i])

    xticks = entries[:, 1]
    plt.xticks(x, xticks)
    plt.grid(linestyle='dashed')
    plt.legend(base_images, loc='upper left', bbox_to_anchor=(1.04, 0.96), borderaxespad=0)
    #plt.legend(base_images, ncol=1, prop={'size': 6})
    plt.xlim([0.5, 12.5])
    #plt.ylim([0.01, 0.12])
    plt.xlabel('p')
    plt.ylabel(r'$ Std\left(\frac{||x - x_0||_p}{||x_0||_p}\right)$')
    plt.ticklabel_format(axis='y', style='sci', scilimits=(-3, 4))
    plt.savefig('std_plot.eps', bbox_inches='tight')
    #plt.show()
    plt.close()


if __name__ == '__main__':
    main()
